package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * An event, associated with a resource or subject type.
 **/
@ApiModel(description = "An event, associated with a resource or subject type.")
public class HookEvent   {
  

public enum EventEnum {

    PULLREQUEST_UNAPPROVED(String.valueOf("pullrequest:unapproved")), ISSUE_COMMENT_CREATED(String.valueOf("issue:comment_created")), PULLREQUEST_APPROVED(String.valueOf("pullrequest:approved")), REPO_CREATED(String.valueOf("repo:created")), REPO_DELETED(String.valueOf("repo:deleted")), REPO_IMPORTED(String.valueOf("repo:imported")), PULLREQUEST_COMMENT_UPDATED(String.valueOf("pullrequest:comment_updated")), ISSUE_UPDATED(String.valueOf("issue:updated")), PROJECT_UPDATED(String.valueOf("project:updated")), PULLREQUEST_COMMENT_CREATED(String.valueOf("pullrequest:comment_created")), REPO_COMMIT_STATUS_UPDATED(String.valueOf("repo:commit_status_updated")), PULLREQUEST_UPDATED(String.valueOf("pullrequest:updated")), ISSUE_CREATED(String.valueOf("issue:created")), REPO_FORK(String.valueOf("repo:fork")), PULLREQUEST_COMMENT_DELETED(String.valueOf("pullrequest:comment_deleted")), REPO_COMMIT_STATUS_CREATED(String.valueOf("repo:commit_status_created")), REPO_UPDATED(String.valueOf("repo:updated")), PULLREQUEST_REJECTED(String.valueOf("pullrequest:rejected")), PULLREQUEST_FULFILLED(String.valueOf("pullrequest:fulfilled")), REPO_PUSH(String.valueOf("repo:push")), PULLREQUEST_CREATED(String.valueOf("pullrequest:created")), REPO_TRANSFER(String.valueOf("repo:transfer")), REPO_COMMIT_COMMENT_CREATED(String.valueOf("repo:commit_comment_created"));


    private String value;

    EventEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static EventEnum fromValue(String v) {
        for (EventEnum b : EventEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid EventEnum event;
  private @Valid String description;
  private @Valid String category;
  private @Valid String label;

  /**
   * The event identifier.
   **/
  public HookEvent event(EventEnum event) {
    this.event = event;
    return this;
  }

  
  @ApiModelProperty(value = "The event identifier.")
  @JsonProperty("event")
  public EventEnum getEvent() {
    return event;
  }
  public void setEvent(EventEnum event) {
    this.event = event;
  }

  /**
   * More detailed description of the webhook event type.
   **/
  public HookEvent description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "More detailed description of the webhook event type.")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The category this event belongs to.
   **/
  public HookEvent category(String category) {
    this.category = category;
    return this;
  }

  
  @ApiModelProperty(value = "The category this event belongs to.")
  @JsonProperty("category")
  public String getCategory() {
    return category;
  }
  public void setCategory(String category) {
    this.category = category;
  }

  /**
   * Summary of the webhook event type.
   **/
  public HookEvent label(String label) {
    this.label = label;
    return this;
  }

  
  @ApiModelProperty(value = "Summary of the webhook event type.")
  @JsonProperty("label")
  public String getLabel() {
    return label;
  }
  public void setLabel(String label) {
    this.label = label;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HookEvent hookEvent = (HookEvent) o;
    return Objects.equals(event, hookEvent.event) &&
        Objects.equals(description, hookEvent.description) &&
        Objects.equals(category, hookEvent.category) &&
        Objects.equals(label, hookEvent.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(event, description, category, label);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HookEvent {\n");
    
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

