package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Issue;
import se.bjurr.bitbucketcloud.gen.model.IssueChangeChanges;
import se.bjurr.bitbucketcloud.gen.model.IssueChangeLinks;
import se.bjurr.bitbucketcloud.gen.model.IssueChangeMessage;
import se.bjurr.bitbucketcloud.gen.model.User;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * An issue change.
 **/
@ApiModel(description = "An issue change.")
public class IssueChange   {
  
  private @Valid IssueChangeChanges changes = null;
  private @Valid String type;
  private @Valid String name;
  private @Valid Date createdOn;
  private @Valid Issue issue = null;
  private @Valid IssueChangeLinks links = null;
  private @Valid User user = null;
  private @Valid IssueChangeMessage message = null;

  /**
   **/
  public IssueChange changes(IssueChangeChanges changes) {
    this.changes = changes;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("changes")
  public IssueChangeChanges getChanges() {
    return changes;
  }
  public void setChanges(IssueChangeChanges changes) {
    this.changes = changes;
  }

  /**
   **/
  public IssueChange type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public IssueChange name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   **/
  public IssueChange createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public IssueChange issue(Issue issue) {
    this.issue = issue;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("issue")
  public Issue getIssue() {
    return issue;
  }
  public void setIssue(Issue issue) {
    this.issue = issue;
  }

  /**
   **/
  public IssueChange links(IssueChangeLinks links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public IssueChangeLinks getLinks() {
    return links;
  }
  public void setLinks(IssueChangeLinks links) {
    this.links = links;
  }

  /**
   **/
  public IssueChange user(User user) {
    this.user = user;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("user")
  public User getUser() {
    return user;
  }
  public void setUser(User user) {
    this.user = user;
  }

  /**
   **/
  public IssueChange message(IssueChangeMessage message) {
    this.message = message;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("message")
  public IssueChangeMessage getMessage() {
    return message;
  }
  public void setMessage(IssueChangeMessage message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueChange issueChange = (IssueChange) o;
    return Objects.equals(changes, issueChange.changes) &&
        Objects.equals(type, issueChange.type) &&
        Objects.equals(name, issueChange.name) &&
        Objects.equals(createdOn, issueChange.createdOn) &&
        Objects.equals(issue, issueChange.issue) &&
        Objects.equals(links, issueChange.links) &&
        Objects.equals(user, issueChange.user) &&
        Objects.equals(message, issueChange.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changes, type, name, createdOn, issue, links, user, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueChange {\n");
    
    sb.append("    changes: ").append(toIndentedString(changes)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    issue: ").append(toIndentedString(issue)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

