package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The status of an import or export job
 **/
@ApiModel(description = "The status of an import or export job")
public class IssueJobStatus   {
  
  private @Valid Integer count;
  private @Valid String type;
  private @Valid Integer total;
  private @Valid String phase;

public enum StatusEnum {

    ACCEPTED(String.valueOf("ACCEPTED")), STARTED(String.valueOf("STARTED")), RUNNING(String.valueOf("RUNNING")), FAILURE(String.valueOf("FAILURE"));


    private String value;

    StatusEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String v) {
        for (StatusEnum b : StatusEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid StatusEnum status;
  private @Valid BigDecimal pct;

  /**
   * The total number of issues already imported/exported
   **/
  public IssueJobStatus count(Integer count) {
    this.count = count;
    return this;
  }

  
  @ApiModelProperty(value = "The total number of issues already imported/exported")
  @JsonProperty("count")
  public Integer getCount() {
    return count;
  }
  public void setCount(Integer count) {
    this.count = count;
  }

  /**
   **/
  public IssueJobStatus type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("type")
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   * The total number of issues being imported/exported
   **/
  public IssueJobStatus total(Integer total) {
    this.total = total;
    return this;
  }

  
  @ApiModelProperty(value = "The total number of issues being imported/exported")
  @JsonProperty("total")
  public Integer getTotal() {
    return total;
  }
  public void setTotal(Integer total) {
    this.total = total;
  }

  /**
   * The phase of the import/export job
   **/
  public IssueJobStatus phase(String phase) {
    this.phase = phase;
    return this;
  }

  
  @ApiModelProperty(value = "The phase of the import/export job")
  @JsonProperty("phase")
  public String getPhase() {
    return phase;
  }
  public void setPhase(String phase) {
    this.phase = phase;
  }

  /**
   * The status of the import/export job
   **/
  public IssueJobStatus status(StatusEnum status) {
    this.status = status;
    return this;
  }

  
  @ApiModelProperty(value = "The status of the import/export job")
  @JsonProperty("status")
  public StatusEnum getStatus() {
    return status;
  }
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   * The percentage of issues already imported/exported
   * minimum: 0
   * maximum: 100.0
   **/
  public IssueJobStatus pct(BigDecimal pct) {
    this.pct = pct;
    return this;
  }

  
  @ApiModelProperty(value = "The percentage of issues already imported/exported")
  @JsonProperty("pct")
 @DecimalMin("0") @DecimalMax("100.0")  public BigDecimal getPct() {
    return pct;
  }
  public void setPct(BigDecimal pct) {
    this.pct = pct;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueJobStatus issueJobStatus = (IssueJobStatus) o;
    return Objects.equals(count, issueJobStatus.count) &&
        Objects.equals(type, issueJobStatus.type) &&
        Objects.equals(total, issueJobStatus.total) &&
        Objects.equals(phase, issueJobStatus.phase) &&
        Objects.equals(status, issueJobStatus.status) &&
        Objects.equals(pct, issueJobStatus.pct);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, type, total, phase, status, pct);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueJobStatus {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    phase: ").append(toIndentedString(phase)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    pct: ").append(toIndentedString(pct)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

