package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Activity;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A paged list of activities
 **/
@ApiModel(description = "A paged list of activities")
public class PaginatedActivities   {
  
  private @Valid Integer page;
  private @Valid String previous;
  private @Valid Integer pagelen;
  private @Valid Integer size;
  private @Valid String next;
  private @Valid List<Activity> values = new ArrayList<Activity>();

  /**
   **/
  public PaginatedActivities page(Integer page) {
    this.page = page;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("page")
  public Integer getPage() {
    return page;
  }
  public void setPage(Integer page) {
    this.page = page;
  }

  /**
   **/
  public PaginatedActivities previous(String previous) {
    this.previous = previous;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("previous")
  public String getPrevious() {
    return previous;
  }
  public void setPrevious(String previous) {
    this.previous = previous;
  }

  /**
   **/
  public PaginatedActivities pagelen(Integer pagelen) {
    this.pagelen = pagelen;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("pagelen")
  public Integer getPagelen() {
    return pagelen;
  }
  public void setPagelen(Integer pagelen) {
    this.pagelen = pagelen;
  }

  /**
   **/
  public PaginatedActivities size(Integer size) {
    this.size = size;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("size")
  public Integer getSize() {
    return size;
  }
  public void setSize(Integer size) {
    this.size = size;
  }

  /**
   **/
  public PaginatedActivities next(String next) {
    this.next = next;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("next")
  public String getNext() {
    return next;
  }
  public void setNext(String next) {
    this.next = next;
  }

  /**
   **/
  public PaginatedActivities values(List<Activity> values) {
    this.values = values;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("values")
 @Size(min=0)  public List<Activity> getValues() {
    return values;
  }
  public void setValues(List<Activity> values) {
    this.values = values;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedActivities paginatedActivities = (PaginatedActivities) o;
    return Objects.equals(page, paginatedActivities.page) &&
        Objects.equals(previous, paginatedActivities.previous) &&
        Objects.equals(pagelen, paginatedActivities.pagelen) &&
        Objects.equals(size, paginatedActivities.size) &&
        Objects.equals(next, paginatedActivities.next) &&
        Objects.equals(values, paginatedActivities.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, previous, pagelen, size, next, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedActivities {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    pagelen: ").append(toIndentedString(pagelen)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

