package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.User;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Participant extends Object  {
  
  private @Valid User user = null;
  private @Valid Date participatedOn;
  private @Valid Boolean approved;

public enum RoleEnum {

    PARTICIPANT(String.valueOf("PARTICIPANT")), REVIEWER(String.valueOf("REVIEWER"));


    private String value;

    RoleEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static RoleEnum fromValue(String v) {
        for (RoleEnum b : RoleEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid RoleEnum role;

  /**
   **/
  public Participant user(User user) {
    this.user = user;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("user")
  public User getUser() {
    return user;
  }
  public void setUser(User user) {
    this.user = user;
  }

  /**
   * The ISO8601 timestamp of the participant&#39;s action. For approvers, this is the time of their approval. For commenters and pull request reviewers who are not approvers, this is the time they last commented, or null if they have not commented.
   **/
  public Participant participatedOn(Date participatedOn) {
    this.participatedOn = participatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "The ISO8601 timestamp of the participant's action. For approvers, this is the time of their approval. For commenters and pull request reviewers who are not approvers, this is the time they last commented, or null if they have not commented.")
  @JsonProperty("participated_on")
  public Date getParticipatedOn() {
    return participatedOn;
  }
  public void setParticipatedOn(Date participatedOn) {
    this.participatedOn = participatedOn;
  }

  /**
   **/
  public Participant approved(Boolean approved) {
    this.approved = approved;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("approved")
  public Boolean getApproved() {
    return approved;
  }
  public void setApproved(Boolean approved) {
    this.approved = approved;
  }

  /**
   **/
  public Participant role(RoleEnum role) {
    this.role = role;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("role")
  public RoleEnum getRole() {
    return role;
  }
  public void setRole(RoleEnum role) {
    this.role = role;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Participant participant = (Participant) o;
    return Objects.equals(user, participant.user) &&
        Objects.equals(participatedOn, participant.participatedOn) &&
        Objects.equals(approved, participant.approved) &&
        Objects.equals(role, participant.role);
  }

  @Override
  public int hashCode() {
    return Objects.hash(user, participatedOn, approved, role);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Participant {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    participatedOn: ").append(toIndentedString(participatedOn)).append("\n");
    sb.append("    approved: ").append(toIndentedString(approved)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

