package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.PipelineState;
import se.bjurr.bitbucketcloud.gen.model.PipelineTarget;
import se.bjurr.bitbucketcloud.gen.model.PipelineTrigger;
import se.bjurr.bitbucketcloud.gen.model.Repository;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Pipeline extends Object  {
  
  private @Valid Date createdOn;
  private @Valid Date completedOn;
  private @Valid PipelineTarget target = null;
  private @Valid Integer buildNumber;
  private @Valid PipelineState state = null;
  private @Valid Integer buildSecondsUsed;
  private @Valid Repository repository = null;
  private @Valid Account creator = null;
  private @Valid String uuid;
  private @Valid PipelineTrigger trigger = null;

  /**
   * The timestamp when the pipeline was created.
   **/
  public Pipeline createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the pipeline was created.")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   * The timestamp when the Pipeline was completed. This is not set if the pipeline is still in progress.
   **/
  public Pipeline completedOn(Date completedOn) {
    this.completedOn = completedOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the Pipeline was completed. This is not set if the pipeline is still in progress.")
  @JsonProperty("completed_on")
  public Date getCompletedOn() {
    return completedOn;
  }
  public void setCompletedOn(Date completedOn) {
    this.completedOn = completedOn;
  }

  /**
   **/
  public Pipeline target(PipelineTarget target) {
    this.target = target;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("target")
  public PipelineTarget getTarget() {
    return target;
  }
  public void setTarget(PipelineTarget target) {
    this.target = target;
  }

  /**
   * The build number of the pipeline.
   **/
  public Pipeline buildNumber(Integer buildNumber) {
    this.buildNumber = buildNumber;
    return this;
  }

  
  @ApiModelProperty(value = "The build number of the pipeline.")
  @JsonProperty("build_number")
  public Integer getBuildNumber() {
    return buildNumber;
  }
  public void setBuildNumber(Integer buildNumber) {
    this.buildNumber = buildNumber;
  }

  /**
   **/
  public Pipeline state(PipelineState state) {
    this.state = state;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("state")
  public PipelineState getState() {
    return state;
  }
  public void setState(PipelineState state) {
    this.state = state;
  }

  /**
   * The number of build seconds used by this pipeline.
   **/
  public Pipeline buildSecondsUsed(Integer buildSecondsUsed) {
    this.buildSecondsUsed = buildSecondsUsed;
    return this;
  }

  
  @ApiModelProperty(value = "The number of build seconds used by this pipeline.")
  @JsonProperty("build_seconds_used")
  public Integer getBuildSecondsUsed() {
    return buildSecondsUsed;
  }
  public void setBuildSecondsUsed(Integer buildSecondsUsed) {
    this.buildSecondsUsed = buildSecondsUsed;
  }

  /**
   **/
  public Pipeline repository(Repository repository) {
    this.repository = repository;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("repository")
  public Repository getRepository() {
    return repository;
  }
  public void setRepository(Repository repository) {
    this.repository = repository;
  }

  /**
   **/
  public Pipeline creator(Account creator) {
    this.creator = creator;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("creator")
  public Account getCreator() {
    return creator;
  }
  public void setCreator(Account creator) {
    this.creator = creator;
  }

  /**
   * The UUID identifying the pipeline.
   **/
  public Pipeline uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the pipeline.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   **/
  public Pipeline trigger(PipelineTrigger trigger) {
    this.trigger = trigger;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("trigger")
  public PipelineTrigger getTrigger() {
    return trigger;
  }
  public void setTrigger(PipelineTrigger trigger) {
    this.trigger = trigger;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Pipeline pipeline = (Pipeline) o;
    return Objects.equals(createdOn, pipeline.createdOn) &&
        Objects.equals(completedOn, pipeline.completedOn) &&
        Objects.equals(target, pipeline.target) &&
        Objects.equals(buildNumber, pipeline.buildNumber) &&
        Objects.equals(state, pipeline.state) &&
        Objects.equals(buildSecondsUsed, pipeline.buildSecondsUsed) &&
        Objects.equals(repository, pipeline.repository) &&
        Objects.equals(creator, pipeline.creator) &&
        Objects.equals(uuid, pipeline.uuid) &&
        Objects.equals(trigger, pipeline.trigger);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdOn, completedOn, target, buildNumber, state, buildSecondsUsed, repository, creator, uuid, trigger);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Pipeline {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    completedOn: ").append(toIndentedString(completedOn)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    buildNumber: ").append(toIndentedString(buildNumber)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    buildSecondsUsed: ").append(toIndentedString(buildSecondsUsed)).append("\n");
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    trigger: ").append(toIndentedString(trigger)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

