package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineBuildNumber extends Object  {
  
  private @Valid Integer next;

  /**
   * The next number that will be used as build number.
   **/
  public PipelineBuildNumber next(Integer next) {
    this.next = next;
    return this;
  }

  
  @ApiModelProperty(value = "The next number that will be used as build number.")
  @JsonProperty("next")
  public Integer getNext() {
    return next;
  }
  public void setNext(Integer next) {
    this.next = next;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineBuildNumber pipelineBuildNumber = (PipelineBuildNumber) o;
    return Objects.equals(next, pipelineBuildNumber.next);
  }

  @Override
  public int hashCode() {
    return Objects.hash(next);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineBuildNumber {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

