package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import se.bjurr.bitbucketcloud.gen.model.PipelineSelector;
import se.bjurr.bitbucketcloud.gen.model.PipelineTarget;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineCommitTarget extends PipelineTarget  {
  
  private @Valid PipelineSelector selector = null;
  private @Valid Commit commit = null;

  /**
   **/
  public PipelineCommitTarget selector(PipelineSelector selector) {
    this.selector = selector;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("selector")
  public PipelineSelector getSelector() {
    return selector;
  }
  public void setSelector(PipelineSelector selector) {
    this.selector = selector;
  }

  /**
   **/
  public PipelineCommitTarget commit(Commit commit) {
    this.commit = commit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("commit")
  public Commit getCommit() {
    return commit;
  }
  public void setCommit(Commit commit) {
    this.commit = commit;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineCommitTarget pipelineCommitTarget = (PipelineCommitTarget) o;
    return Objects.equals(selector, pipelineCommitTarget.selector) &&
        Objects.equals(commit, pipelineCommitTarget.commit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(selector, commit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineCommitTarget {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    selector: ").append(toIndentedString(selector)).append("\n");
    sb.append("    commit: ").append(toIndentedString(commit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

