package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import se.bjurr.bitbucketcloud.gen.model.PipelineSelector;
import se.bjurr.bitbucketcloud.gen.model.PipelineTarget;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineRefTarget extends PipelineTarget  {
  

public enum RefTypeEnum {

    BRANCH(String.valueOf("branch")), TAG(String.valueOf("tag")), NAMED_BRANCH(String.valueOf("named_branch")), BOOKMARK(String.valueOf("bookmark"));


    private String value;

    RefTypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static RefTypeEnum fromValue(String v) {
        for (RefTypeEnum b : RefTypeEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid RefTypeEnum refType;
  private @Valid Commit commit = null;
  private @Valid String refName;
  private @Valid PipelineSelector selector = null;

  /**
   * The type of reference (branch/tag).
   **/
  public PipelineRefTarget refType(RefTypeEnum refType) {
    this.refType = refType;
    return this;
  }

  
  @ApiModelProperty(value = "The type of reference (branch/tag).")
  @JsonProperty("ref_type")
  public RefTypeEnum getRefType() {
    return refType;
  }
  public void setRefType(RefTypeEnum refType) {
    this.refType = refType;
  }

  /**
   **/
  public PipelineRefTarget commit(Commit commit) {
    this.commit = commit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("commit")
  public Commit getCommit() {
    return commit;
  }
  public void setCommit(Commit commit) {
    this.commit = commit;
  }

  /**
   * The name of the reference.
   **/
  public PipelineRefTarget refName(String refName) {
    this.refName = refName;
    return this;
  }

  
  @ApiModelProperty(value = "The name of the reference.")
  @JsonProperty("ref_name")
  public String getRefName() {
    return refName;
  }
  public void setRefName(String refName) {
    this.refName = refName;
  }

  /**
   **/
  public PipelineRefTarget selector(PipelineSelector selector) {
    this.selector = selector;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("selector")
  public PipelineSelector getSelector() {
    return selector;
  }
  public void setSelector(PipelineSelector selector) {
    this.selector = selector;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineRefTarget pipelineRefTarget = (PipelineRefTarget) o;
    return Objects.equals(refType, pipelineRefTarget.refType) &&
        Objects.equals(commit, pipelineRefTarget.commit) &&
        Objects.equals(refName, pipelineRefTarget.refName) &&
        Objects.equals(selector, pipelineRefTarget.selector);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refType, commit, refName, selector);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineRefTarget {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    refType: ").append(toIndentedString(refType)).append("\n");
    sb.append("    commit: ").append(toIndentedString(commit)).append("\n");
    sb.append("    refName: ").append(toIndentedString(refName)).append("\n");
    sb.append("    selector: ").append(toIndentedString(selector)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

