package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.PipelineSelector;
import se.bjurr.bitbucketcloud.gen.model.PipelineTarget;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineSchedule extends Object  {
  
  private @Valid Date createdOn;
  private @Valid PipelineTarget target = null;
  private @Valid Date updatedOn;
  private @Valid Boolean enabled;
  private @Valid PipelineSelector selector = null;
  private @Valid String cronPattern;
  private @Valid String uuid;

  /**
   * The timestamp when the schedule was created.
   **/
  public PipelineSchedule createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the schedule was created.")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public PipelineSchedule target(PipelineTarget target) {
    this.target = target;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("target")
  public PipelineTarget getTarget() {
    return target;
  }
  public void setTarget(PipelineTarget target) {
    this.target = target;
  }

  /**
   * The timestamp when the schedule was updated.
   **/
  public PipelineSchedule updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the schedule was updated.")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   * Whether the schedule is enabled.
   **/
  public PipelineSchedule enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  
  @ApiModelProperty(value = "Whether the schedule is enabled.")
  @JsonProperty("enabled")
  public Boolean getEnabled() {
    return enabled;
  }
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  /**
   **/
  public PipelineSchedule selector(PipelineSelector selector) {
    this.selector = selector;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("selector")
  public PipelineSelector getSelector() {
    return selector;
  }
  public void setSelector(PipelineSelector selector) {
    this.selector = selector;
  }

  /**
   * The cron expression that the schedule applies.
   **/
  public PipelineSchedule cronPattern(String cronPattern) {
    this.cronPattern = cronPattern;
    return this;
  }

  
  @ApiModelProperty(value = "The cron expression that the schedule applies.")
  @JsonProperty("cron_pattern")
  public String getCronPattern() {
    return cronPattern;
  }
  public void setCronPattern(String cronPattern) {
    this.cronPattern = cronPattern;
  }

  /**
   * The UUID identifying the schedule.
   **/
  public PipelineSchedule uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the schedule.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineSchedule pipelineSchedule = (PipelineSchedule) o;
    return Objects.equals(createdOn, pipelineSchedule.createdOn) &&
        Objects.equals(target, pipelineSchedule.target) &&
        Objects.equals(updatedOn, pipelineSchedule.updatedOn) &&
        Objects.equals(enabled, pipelineSchedule.enabled) &&
        Objects.equals(selector, pipelineSchedule.selector) &&
        Objects.equals(cronPattern, pipelineSchedule.cronPattern) &&
        Objects.equals(uuid, pipelineSchedule.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdOn, target, updatedOn, enabled, selector, cronPattern, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineSchedule {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    selector: ").append(toIndentedString(selector)).append("\n");
    sb.append("    cronPattern: ").append(toIndentedString(cronPattern)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

