package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineSshKeyPair extends Object  {
  
  private @Valid String publicKey;
  private @Valid String privateKey;

  /**
   * The SSH public key.
   **/
  public PipelineSshKeyPair publicKey(String publicKey) {
    this.publicKey = publicKey;
    return this;
  }

  
  @ApiModelProperty(value = "The SSH public key.")
  @JsonProperty("public_key")
  public String getPublicKey() {
    return publicKey;
  }
  public void setPublicKey(String publicKey) {
    this.publicKey = publicKey;
  }

  /**
   * The SSH private key. This value will be empty when retrieving the SSH key pair.
   **/
  public PipelineSshKeyPair privateKey(String privateKey) {
    this.privateKey = privateKey;
    return this;
  }

  
  @ApiModelProperty(value = "The SSH private key. This value will be empty when retrieving the SSH key pair.")
  @JsonProperty("private_key")
  public String getPrivateKey() {
    return privateKey;
  }
  public void setPrivateKey(String privateKey) {
    this.privateKey = privateKey;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineSshKeyPair pipelineSshKeyPair = (PipelineSshKeyPair) o;
    return Objects.equals(publicKey, pipelineSshKeyPair.publicKey) &&
        Objects.equals(privateKey, pipelineSshKeyPair.privateKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(publicKey, privateKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineSshKeyPair {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("    privateKey: ").append(toIndentedString(privateKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

