package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.PipelineState;
import se.bjurr.bitbucketcloud.gen.model.PipelineStateInProgressStage;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineStateInProgress extends PipelineState  {
  

public enum NameEnum {

    IN_PROGRESS(String.valueOf("IN_PROGRESS"));


    private String value;

    NameEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static NameEnum fromValue(String v) {
        for (NameEnum b : NameEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid NameEnum name;
  private @Valid PipelineStateInProgressStage stage = null;

  /**
   * The name of pipeline state (IN_PROGRESS).
   **/
  public PipelineStateInProgress name(NameEnum name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of pipeline state (IN_PROGRESS).")
  @JsonProperty("name")
  public NameEnum getName() {
    return name;
  }
  public void setName(NameEnum name) {
    this.name = name;
  }

  /**
   **/
  public PipelineStateInProgress stage(PipelineStateInProgressStage stage) {
    this.stage = stage;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("stage")
  public PipelineStateInProgressStage getStage() {
    return stage;
  }
  public void setStage(PipelineStateInProgressStage stage) {
    this.stage = stage;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineStateInProgress pipelineStateInProgress = (PipelineStateInProgress) o;
    return Objects.equals(name, pipelineStateInProgress.name) &&
        Objects.equals(stage, pipelineStateInProgress.stage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, stage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineStateInProgress {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    stage: ").append(toIndentedString(stage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

