package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineVariable extends Object  {
  
  private @Valid String key;
  private @Valid Boolean secured;
  private @Valid String value;
  private @Valid String uuid;

  /**
   * The unique name of the variable.
   **/
  public PipelineVariable key(String key) {
    this.key = key;
    return this;
  }

  
  @ApiModelProperty(value = "The unique name of the variable.")
  @JsonProperty("key")
  public String getKey() {
    return key;
  }
  public void setKey(String key) {
    this.key = key;
  }

  /**
   * If true, this variable will be treated as secured. The value will never be exposed in the logs or the REST API.
   **/
  public PipelineVariable secured(Boolean secured) {
    this.secured = secured;
    return this;
  }

  
  @ApiModelProperty(value = "If true, this variable will be treated as secured. The value will never be exposed in the logs or the REST API.")
  @JsonProperty("secured")
  public Boolean getSecured() {
    return secured;
  }
  public void setSecured(Boolean secured) {
    this.secured = secured;
  }

  /**
   * The value of the variable. If the variable is secured, this will be empty.
   **/
  public PipelineVariable value(String value) {
    this.value = value;
    return this;
  }

  
  @ApiModelProperty(value = "The value of the variable. If the variable is secured, this will be empty.")
  @JsonProperty("value")
  public String getValue() {
    return value;
  }
  public void setValue(String value) {
    this.value = value;
  }

  /**
   * The UUID identifying the variable.
   **/
  public PipelineVariable uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the variable.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineVariable pipelineVariable = (PipelineVariable) o;
    return Objects.equals(key, pipelineVariable.key) &&
        Objects.equals(secured, pipelineVariable.secured) &&
        Objects.equals(value, pipelineVariable.value) &&
        Objects.equals(uuid, pipelineVariable.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, secured, value, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineVariable {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    secured: ").append(toIndentedString(secured)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

