package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Team;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Project extends Object  {
  
  private @Valid Date updatedOn;
  private @Valid Date createdOn;
  private @Valid String name;
  private @Valid String key;
  private @Valid String description;
  private @Valid Team owner = null;
  private @Valid Boolean isPrivate;
  private @Valid Object links = null;
  private @Valid String uuid;

  /**
   **/
  public Project updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   **/
  public Project createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   * The name of the project.
   **/
  public Project name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of the project.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The project&#39;s key.
   **/
  public Project key(String key) {
    this.key = key;
    return this;
  }

  
  @ApiModelProperty(value = "The project's key.")
  @JsonProperty("key")
  public String getKey() {
    return key;
  }
  public void setKey(String key) {
    this.key = key;
  }

  /**
   **/
  public Project description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public Project owner(Team owner) {
    this.owner = owner;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("owner")
  public Team getOwner() {
    return owner;
  }
  public void setOwner(Team owner) {
    this.owner = owner;
  }

  /**
   *  Indicates whether the project is publicly accessible, or whether it is private to the team and consequently only visible to team members. Note that private projects cannot contain public repositories.
   **/
  public Project isPrivate(Boolean isPrivate) {
    this.isPrivate = isPrivate;
    return this;
  }

  
  @ApiModelProperty(value = " Indicates whether the project is publicly accessible, or whether it is private to the team and consequently only visible to team members. Note that private projects cannot contain public repositories.")
  @JsonProperty("is_private")
  public Boolean getIsPrivate() {
    return isPrivate;
  }
  public void setIsPrivate(Boolean isPrivate) {
    this.isPrivate = isPrivate;
  }

  /**
   **/
  public Project links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * The project&#39;s immutable id.
   **/
  public Project uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The project's immutable id.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Project project = (Project) o;
    return Objects.equals(updatedOn, project.updatedOn) &&
        Objects.equals(createdOn, project.createdOn) &&
        Objects.equals(name, project.name) &&
        Objects.equals(key, project.key) &&
        Objects.equals(description, project.description) &&
        Objects.equals(owner, project.owner) &&
        Objects.equals(isPrivate, project.isPrivate) &&
        Objects.equals(links, project.links) &&
        Objects.equals(uuid, project.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(updatedOn, createdOn, name, key, description, owner, isPrivate, links, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Project {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    isPrivate: ").append(toIndentedString(isPrivate)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

