package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.PullrequestEndpointBranch;
import se.bjurr.bitbucketcloud.gen.model.PullrequestEndpointCommit;
import se.bjurr.bitbucketcloud.gen.model.Repository;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PullrequestEndpoint   {
  
  private @Valid Repository repository = null;
  private @Valid PullrequestEndpointCommit commit = null;
  private @Valid PullrequestEndpointBranch branch = null;

  /**
   **/
  public PullrequestEndpoint repository(Repository repository) {
    this.repository = repository;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("repository")
  public Repository getRepository() {
    return repository;
  }
  public void setRepository(Repository repository) {
    this.repository = repository;
  }

  /**
   **/
  public PullrequestEndpoint commit(PullrequestEndpointCommit commit) {
    this.commit = commit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("commit")
  public PullrequestEndpointCommit getCommit() {
    return commit;
  }
  public void setCommit(PullrequestEndpointCommit commit) {
    this.commit = commit;
  }

  /**
   **/
  public PullrequestEndpoint branch(PullrequestEndpointBranch branch) {
    this.branch = branch;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("branch")
  public PullrequestEndpointBranch getBranch() {
    return branch;
  }
  public void setBranch(PullrequestEndpointBranch branch) {
    this.branch = branch;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PullrequestEndpoint pullrequestEndpoint = (PullrequestEndpoint) o;
    return Objects.equals(repository, pullrequestEndpoint.repository) &&
        Objects.equals(commit, pullrequestEndpoint.commit) &&
        Objects.equals(branch, pullrequestEndpoint.branch);
  }

  @Override
  public int hashCode() {
    return Objects.hash(repository, commit, branch);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PullrequestEndpoint {\n");
    
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("    commit: ").append(toIndentedString(commit)).append("\n");
    sb.append("    branch: ").append(toIndentedString(branch)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

