package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PullrequestEndpointBranch   {
  
  private @Valid String defaultMergeStrategy;
  private @Valid String name;
 
public enum MergeStrategiesEnum {

    MERGE_COMMIT(String.valueOf("merge_commit")), SQUASH(String.valueOf("squash")), FAST_FORWARD(String.valueOf("fast_forward"));


    private String value;

    MergeStrategiesEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static MergeStrategiesEnum fromValue(String v) {
        for (MergeStrategiesEnum b : MergeStrategiesEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid List<MergeStrategiesEnum> mergeStrategies = new ArrayList<MergeStrategiesEnum>();

  /**
   * The default merge strategy, when this endpoint is the destination of the pull request.
   **/
  public PullrequestEndpointBranch defaultMergeStrategy(String defaultMergeStrategy) {
    this.defaultMergeStrategy = defaultMergeStrategy;
    return this;
  }

  
  @ApiModelProperty(value = "The default merge strategy, when this endpoint is the destination of the pull request.")
  @JsonProperty("default_merge_strategy")
  public String getDefaultMergeStrategy() {
    return defaultMergeStrategy;
  }
  public void setDefaultMergeStrategy(String defaultMergeStrategy) {
    this.defaultMergeStrategy = defaultMergeStrategy;
  }

  /**
   **/
  public PullrequestEndpointBranch name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Available merge strategies, when this endpoint is the destination of the pull request.
   **/
  public PullrequestEndpointBranch mergeStrategies(List<MergeStrategiesEnum> mergeStrategies) {
    this.mergeStrategies = mergeStrategies;
    return this;
  }

  
  @ApiModelProperty(value = "Available merge strategies, when this endpoint is the destination of the pull request.")
  @JsonProperty("merge_strategies")
  public List<MergeStrategiesEnum> getMergeStrategies() {
    return mergeStrategies;
  }
  public void setMergeStrategies(List<MergeStrategiesEnum> mergeStrategies) {
    this.mergeStrategies = mergeStrategies;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PullrequestEndpointBranch pullrequestEndpointBranch = (PullrequestEndpointBranch) o;
    return Objects.equals(defaultMergeStrategy, pullrequestEndpointBranch.defaultMergeStrategy) &&
        Objects.equals(name, pullrequestEndpointBranch.name) &&
        Objects.equals(mergeStrategies, pullrequestEndpointBranch.mergeStrategies);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultMergeStrategy, name, mergeStrategies);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PullrequestEndpointBranch {\n");
    
    sb.append("    defaultMergeStrategy: ").append(toIndentedString(defaultMergeStrategy)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    mergeStrategies: ").append(toIndentedString(mergeStrategies)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

