package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.Branch;
import se.bjurr.bitbucketcloud.gen.model.Project;
import se.bjurr.bitbucketcloud.gen.model.Repository;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Repository extends Object  {
  
  private @Valid String name;
  private @Valid String description;
  private @Valid Repository parent = null;

public enum ScmEnum {

    HG(String.valueOf("hg")), GIT(String.valueOf("git"));


    private String value;

    ScmEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ScmEnum fromValue(String v) {
        for (ScmEnum b : ScmEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid ScmEnum scm;
  private @Valid Project project = null;

public enum ForkPolicyEnum {

    ALLOW_FORKS(String.valueOf("allow_forks")), NO_PUBLIC_FORKS(String.valueOf("no_public_forks")), NO_FORKS(String.valueOf("no_forks"));


    private String value;

    ForkPolicyEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ForkPolicyEnum fromValue(String v) {
        for (ForkPolicyEnum b : ForkPolicyEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid ForkPolicyEnum forkPolicy;
  private @Valid Boolean hasIssues;
  private @Valid String fullName;
  private @Valid Integer size;
  private @Valid Date createdOn;
  private @Valid Date updatedOn;
  private @Valid Account owner = null;
  private @Valid Branch mainbranch = null;
  private @Valid String language;
  private @Valid Boolean hasWiki;
  private @Valid Boolean isPrivate;
  private @Valid String uuid;
  private @Valid Object links = null;

  /**
   **/
  public Repository name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   **/
  public Repository description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public Repository parent(Repository parent) {
    this.parent = parent;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("parent")
  public Repository getParent() {
    return parent;
  }
  public void setParent(Repository parent) {
    this.parent = parent;
  }

  /**
   **/
  public Repository scm(ScmEnum scm) {
    this.scm = scm;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("scm")
  public ScmEnum getScm() {
    return scm;
  }
  public void setScm(ScmEnum scm) {
    this.scm = scm;
  }

  /**
   **/
  public Repository project(Project project) {
    this.project = project;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("project")
  public Project getProject() {
    return project;
  }
  public void setProject(Project project) {
    this.project = project;
  }

  /**
   *  Controls the rules for forking this repository.  * **allow_forks**: unrestricted forking * **no_public_forks**: restrict forking to private forks (forks cannot   be made public later) * **no_forks**: deny all forking 
   **/
  public Repository forkPolicy(ForkPolicyEnum forkPolicy) {
    this.forkPolicy = forkPolicy;
    return this;
  }

  
  @ApiModelProperty(value = " Controls the rules for forking this repository.  * **allow_forks**: unrestricted forking * **no_public_forks**: restrict forking to private forks (forks cannot   be made public later) * **no_forks**: deny all forking ")
  @JsonProperty("fork_policy")
  public ForkPolicyEnum getForkPolicy() {
    return forkPolicy;
  }
  public void setForkPolicy(ForkPolicyEnum forkPolicy) {
    this.forkPolicy = forkPolicy;
  }

  /**
   **/
  public Repository hasIssues(Boolean hasIssues) {
    this.hasIssues = hasIssues;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("has_issues")
  public Boolean getHasIssues() {
    return hasIssues;
  }
  public void setHasIssues(Boolean hasIssues) {
    this.hasIssues = hasIssues;
  }

  /**
   * The concatenation of the repository owner&#39;s username and the slugified name, e.g. \&quot;evzijst/interruptingcow\&quot;. This is the same string used in Bitbucket URLs.
   **/
  public Repository fullName(String fullName) {
    this.fullName = fullName;
    return this;
  }

  
  @ApiModelProperty(value = "The concatenation of the repository owner's username and the slugified name, e.g. \"evzijst/interruptingcow\". This is the same string used in Bitbucket URLs.")
  @JsonProperty("full_name")
  public String getFullName() {
    return fullName;
  }
  public void setFullName(String fullName) {
    this.fullName = fullName;
  }

  /**
   **/
  public Repository size(Integer size) {
    this.size = size;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("size")
  public Integer getSize() {
    return size;
  }
  public void setSize(Integer size) {
    this.size = size;
  }

  /**
   **/
  public Repository createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public Repository updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   **/
  public Repository owner(Account owner) {
    this.owner = owner;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("owner")
  public Account getOwner() {
    return owner;
  }
  public void setOwner(Account owner) {
    this.owner = owner;
  }

  /**
   **/
  public Repository mainbranch(Branch mainbranch) {
    this.mainbranch = mainbranch;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("mainbranch")
  public Branch getMainbranch() {
    return mainbranch;
  }
  public void setMainbranch(Branch mainbranch) {
    this.mainbranch = mainbranch;
  }

  /**
   **/
  public Repository language(String language) {
    this.language = language;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("language")
  public String getLanguage() {
    return language;
  }
  public void setLanguage(String language) {
    this.language = language;
  }

  /**
   **/
  public Repository hasWiki(Boolean hasWiki) {
    this.hasWiki = hasWiki;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("has_wiki")
  public Boolean getHasWiki() {
    return hasWiki;
  }
  public void setHasWiki(Boolean hasWiki) {
    this.hasWiki = hasWiki;
  }

  /**
   **/
  public Repository isPrivate(Boolean isPrivate) {
    this.isPrivate = isPrivate;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("is_private")
  public Boolean getIsPrivate() {
    return isPrivate;
  }
  public void setIsPrivate(Boolean isPrivate) {
    this.isPrivate = isPrivate;
  }

  /**
   * The repository&#39;s immutable id. This can be used as a substitute for the slug segment in URLs. Doing this guarantees your URLs will survive renaming of the repository by its owner, or even transfer of the repository to a different user.
   **/
  public Repository uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The repository's immutable id. This can be used as a substitute for the slug segment in URLs. Doing this guarantees your URLs will survive renaming of the repository by its owner, or even transfer of the repository to a different user.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   **/
  public Repository links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Repository repository = (Repository) o;
    return Objects.equals(name, repository.name) &&
        Objects.equals(description, repository.description) &&
        Objects.equals(parent, repository.parent) &&
        Objects.equals(scm, repository.scm) &&
        Objects.equals(project, repository.project) &&
        Objects.equals(forkPolicy, repository.forkPolicy) &&
        Objects.equals(hasIssues, repository.hasIssues) &&
        Objects.equals(fullName, repository.fullName) &&
        Objects.equals(size, repository.size) &&
        Objects.equals(createdOn, repository.createdOn) &&
        Objects.equals(updatedOn, repository.updatedOn) &&
        Objects.equals(owner, repository.owner) &&
        Objects.equals(mainbranch, repository.mainbranch) &&
        Objects.equals(language, repository.language) &&
        Objects.equals(hasWiki, repository.hasWiki) &&
        Objects.equals(isPrivate, repository.isPrivate) &&
        Objects.equals(uuid, repository.uuid) &&
        Objects.equals(links, repository.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, parent, scm, project, forkPolicy, hasIssues, fullName, size, createdOn, updatedOn, owner, mainbranch, language, hasWiki, isPrivate, uuid, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Repository {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    scm: ").append(toIndentedString(scm)).append("\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    forkPolicy: ").append(toIndentedString(forkPolicy)).append("\n");
    sb.append("    hasIssues: ").append(toIndentedString(hasIssues)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    mainbranch: ").append(toIndentedString(mainbranch)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    hasWiki: ").append(toIndentedString(hasWiki)).append("\n");
    sb.append("    isPrivate: ").append(toIndentedString(isPrivate)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

