package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.CommitFile;
import se.bjurr.bitbucketcloud.gen.model.SearchContentMatch;
import se.bjurr.bitbucketcloud.gen.model.SearchSegment;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class SearchCodeSearchResult   {
  
  private @Valid CommitFile file = null;
  private @Valid List<SearchSegment> pathMatches = new ArrayList<SearchSegment>();
  private @Valid String type;
  private @Valid List<SearchContentMatch> contentMatches = new ArrayList<SearchContentMatch>();
  private @Valid Long contentMatchCount;

  /**
   **/
  public SearchCodeSearchResult file(CommitFile file) {
    this.file = file;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("file")
  public CommitFile getFile() {
    return file;
  }
  public void setFile(CommitFile file) {
    this.file = file;
  }

  /**
   **/
  public SearchCodeSearchResult pathMatches(List<SearchSegment> pathMatches) {
    this.pathMatches = pathMatches;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("path_matches")
  public List<SearchSegment> getPathMatches() {
    return pathMatches;
  }
  public void setPathMatches(List<SearchSegment> pathMatches) {
    this.pathMatches = pathMatches;
  }

  /**
   **/
  public SearchCodeSearchResult type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("type")
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public SearchCodeSearchResult contentMatches(List<SearchContentMatch> contentMatches) {
    this.contentMatches = contentMatches;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("content_matches")
  public List<SearchContentMatch> getContentMatches() {
    return contentMatches;
  }
  public void setContentMatches(List<SearchContentMatch> contentMatches) {
    this.contentMatches = contentMatches;
  }

  /**
   **/
  public SearchCodeSearchResult contentMatchCount(Long contentMatchCount) {
    this.contentMatchCount = contentMatchCount;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("content_match_count")
  public Long getContentMatchCount() {
    return contentMatchCount;
  }
  public void setContentMatchCount(Long contentMatchCount) {
    this.contentMatchCount = contentMatchCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchCodeSearchResult searchCodeSearchResult = (SearchCodeSearchResult) o;
    return Objects.equals(file, searchCodeSearchResult.file) &&
        Objects.equals(pathMatches, searchCodeSearchResult.pathMatches) &&
        Objects.equals(type, searchCodeSearchResult.type) &&
        Objects.equals(contentMatches, searchCodeSearchResult.contentMatches) &&
        Objects.equals(contentMatchCount, searchCodeSearchResult.contentMatchCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(file, pathMatches, type, contentMatches, contentMatchCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchCodeSearchResult {\n");
    
    sb.append("    file: ").append(toIndentedString(file)).append("\n");
    sb.append("    pathMatches: ").append(toIndentedString(pathMatches)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    contentMatches: ").append(toIndentedString(contentMatches)).append("\n");
    sb.append("    contentMatchCount: ").append(toIndentedString(contentMatchCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

