package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.SearchSegment;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class SearchLine   {
  
  private @Valid List<SearchSegment> segments = new ArrayList<SearchSegment>();
  private @Valid Integer line;

  /**
   **/
  public SearchLine segments(List<SearchSegment> segments) {
    this.segments = segments;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("segments")
  public List<SearchSegment> getSegments() {
    return segments;
  }
  public void setSegments(List<SearchSegment> segments) {
    this.segments = segments;
  }

  /**
   **/
  public SearchLine line(Integer line) {
    this.line = line;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("line")
  public Integer getLine() {
    return line;
  }
  public void setLine(Integer line) {
    this.line = line;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchLine searchLine = (SearchLine) o;
    return Objects.equals(segments, searchLine.segments) &&
        Objects.equals(line, searchLine.line);
  }

  @Override
  public int hashCode() {
    return Objects.hash(segments, line);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchLine {\n");
    
    sb.append("    segments: ").append(toIndentedString(segments)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

