package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Snippet extends Object  {
  
  private @Valid Boolean isPrivate;
  private @Valid Account creator = null;

public enum ScmEnum {

    HG(String.valueOf("hg")), GIT(String.valueOf("git"));


    private String value;

    ScmEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ScmEnum fromValue(String v) {
        for (ScmEnum b : ScmEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid ScmEnum scm;
  private @Valid Date updatedOn;
  private @Valid Integer id;
  private @Valid Date createdOn;
  private @Valid String title;
  private @Valid Account owner = null;

  /**
   **/
  public Snippet isPrivate(Boolean isPrivate) {
    this.isPrivate = isPrivate;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("is_private")
  public Boolean getIsPrivate() {
    return isPrivate;
  }
  public void setIsPrivate(Boolean isPrivate) {
    this.isPrivate = isPrivate;
  }

  /**
   **/
  public Snippet creator(Account creator) {
    this.creator = creator;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("creator")
  public Account getCreator() {
    return creator;
  }
  public void setCreator(Account creator) {
    this.creator = creator;
  }

  /**
   * The DVCS used to store the snippet.
   **/
  public Snippet scm(ScmEnum scm) {
    this.scm = scm;
    return this;
  }

  
  @ApiModelProperty(value = "The DVCS used to store the snippet.")
  @JsonProperty("scm")
  public ScmEnum getScm() {
    return scm;
  }
  public void setScm(ScmEnum scm) {
    this.scm = scm;
  }

  /**
   **/
  public Snippet updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   * minimum: 0
   **/
  public Snippet id(Integer id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("id")
 @Min(0)  public Integer getId() {
    return id;
  }
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   **/
  public Snippet createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public Snippet title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public Snippet owner(Account owner) {
    this.owner = owner;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("owner")
  public Account getOwner() {
    return owner;
  }
  public void setOwner(Account owner) {
    this.owner = owner;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Snippet snippet = (Snippet) o;
    return Objects.equals(isPrivate, snippet.isPrivate) &&
        Objects.equals(creator, snippet.creator) &&
        Objects.equals(scm, snippet.scm) &&
        Objects.equals(updatedOn, snippet.updatedOn) &&
        Objects.equals(id, snippet.id) &&
        Objects.equals(createdOn, snippet.createdOn) &&
        Objects.equals(title, snippet.title) &&
        Objects.equals(owner, snippet.owner);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isPrivate, creator, scm, updatedOn, id, createdOn, title, owner);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Snippet {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    isPrivate: ").append(toIndentedString(isPrivate)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    scm: ").append(toIndentedString(scm)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

