package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Author;
import se.bjurr.bitbucketcloud.gen.model.BaseCommit;
import se.bjurr.bitbucketcloud.gen.model.Snippet;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class SnippetCommit extends BaseCommit  {
  
  private @Valid Object links = null;
  private @Valid Snippet snippet = null;

  /**
   **/
  public SnippetCommit links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   **/
  public SnippetCommit snippet(Snippet snippet) {
    this.snippet = snippet;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("snippet")
  public Snippet getSnippet() {
    return snippet;
  }
  public void setSnippet(Snippet snippet) {
    this.snippet = snippet;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SnippetCommit snippetCommit = (SnippetCommit) o;
    return Objects.equals(links, snippetCommit.links) &&
        Objects.equals(snippet, snippetCommit.snippet);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, snippet);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SnippetCommit {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    snippet: ").append(toIndentedString(snippet)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

