package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class SshKey extends Object  {
  
  private @Valid Date lastUsed;
  private @Valid String key;
  private @Valid String comment;
  private @Valid Date createdOn;
  private @Valid String uuid;
  private @Valid Object links = null;
  private @Valid String label;

  /**
   **/
  public SshKey lastUsed(Date lastUsed) {
    this.lastUsed = lastUsed;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("last_used")
  public Date getLastUsed() {
    return lastUsed;
  }
  public void setLastUsed(Date lastUsed) {
    this.lastUsed = lastUsed;
  }

  /**
   * The SSH public key value in OpenSSH format.
   **/
  public SshKey key(String key) {
    this.key = key;
    return this;
  }

  
  @ApiModelProperty(value = "The SSH public key value in OpenSSH format.")
  @JsonProperty("key")
  public String getKey() {
    return key;
  }
  public void setKey(String key) {
    this.key = key;
  }

  /**
   * The comment parsed from the SSH key (if present)
   **/
  public SshKey comment(String comment) {
    this.comment = comment;
    return this;
  }

  
  @ApiModelProperty(value = "The comment parsed from the SSH key (if present)")
  @JsonProperty("comment")
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }

  /**
   **/
  public SshKey createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   * The SSH key&#39;s immutable ID.
   **/
  public SshKey uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The SSH key's immutable ID.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   **/
  public SshKey links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * The user-defined label for the SSH key
   **/
  public SshKey label(String label) {
    this.label = label;
    return this;
  }

  
  @ApiModelProperty(value = "The user-defined label for the SSH key")
  @JsonProperty("label")
  public String getLabel() {
    return label;
  }
  public void setLabel(String label) {
    this.label = label;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SshKey sshKey = (SshKey) o;
    return Objects.equals(lastUsed, sshKey.lastUsed) &&
        Objects.equals(key, sshKey.key) &&
        Objects.equals(comment, sshKey.comment) &&
        Objects.equals(createdOn, sshKey.createdOn) &&
        Objects.equals(uuid, sshKey.uuid) &&
        Objects.equals(links, sshKey.links) &&
        Objects.equals(label, sshKey.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lastUsed, key, comment, createdOn, uuid, links, label);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SshKey {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    lastUsed: ").append(toIndentedString(lastUsed)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

