package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.SubjectTypesRepository;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The mapping of resource/subject types pointing to their individual event types.
 **/
@ApiModel(description = "The mapping of resource/subject types pointing to their individual event types.")
public class SubjectTypes   {
  
  private @Valid SubjectTypesRepository repository = null;
  private @Valid SubjectTypesRepository user = null;
  private @Valid SubjectTypesRepository team = null;

  /**
   **/
  public SubjectTypes repository(SubjectTypesRepository repository) {
    this.repository = repository;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("repository")
  public SubjectTypesRepository getRepository() {
    return repository;
  }
  public void setRepository(SubjectTypesRepository repository) {
    this.repository = repository;
  }

  /**
   **/
  public SubjectTypes user(SubjectTypesRepository user) {
    this.user = user;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("user")
  public SubjectTypesRepository getUser() {
    return user;
  }
  public void setUser(SubjectTypesRepository user) {
    this.user = user;
  }

  /**
   **/
  public SubjectTypes team(SubjectTypesRepository team) {
    this.team = team;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("team")
  public SubjectTypesRepository getTeam() {
    return team;
  }
  public void setTeam(SubjectTypesRepository team) {
    this.team = team;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubjectTypes subjectTypes = (SubjectTypes) o;
    return Objects.equals(repository, subjectTypes.repository) &&
        Objects.equals(user, subjectTypes.user) &&
        Objects.equals(team, subjectTypes.team);
  }

  @Override
  public int hashCode() {
    return Objects.hash(repository, user, team);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubjectTypes {\n");
    
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    team: ").append(toIndentedString(team)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

