package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Author;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import se.bjurr.bitbucketcloud.gen.model.Ref;
import se.bjurr.bitbucketcloud.gen.model.RefLinks;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Tag extends Ref  {
  
  private @Valid Author tagger = null;
  private @Valid Date date;
  private @Valid String message;

  /**
   **/
  public Tag tagger(Author tagger) {
    this.tagger = tagger;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("tagger")
  public Author getTagger() {
    return tagger;
  }
  public void setTagger(Author tagger) {
    this.tagger = tagger;
  }

  /**
   * The date that the tag was created, if available
   **/
  public Tag date(Date date) {
    this.date = date;
    return this;
  }

  
  @ApiModelProperty(value = "The date that the tag was created, if available")
  @JsonProperty("date")
  public Date getDate() {
    return date;
  }
  public void setDate(Date date) {
    this.date = date;
  }

  /**
   * The message associated with the tag, if available.
   **/
  public Tag message(String message) {
    this.message = message;
    return this;
  }

  
  @ApiModelProperty(value = "The message associated with the tag, if available.")
  @JsonProperty("message")
  public String getMessage() {
    return message;
  }
  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Tag tag = (Tag) o;
    return Objects.equals(tagger, tag.tagger) &&
        Objects.equals(date, tag.date) &&
        Objects.equals(message, tag.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tagger, date, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Tag {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    tagger: ").append(toIndentedString(tagger)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

