package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Team;
import se.bjurr.bitbucketcloud.gen.model.User;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A user&#39;s permission for a given team.
 **/
@ApiModel(description = "A user's permission for a given team.")
public class TeamPermission   {
  
  private @Valid Team team = null;
  private @Valid String type;

public enum PermissionEnum {

    ADMIN(String.valueOf("admin")), COLLABORATOR(String.valueOf("collaborator"));


    private String value;

    PermissionEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static PermissionEnum fromValue(String v) {
        for (PermissionEnum b : PermissionEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid PermissionEnum permission;
  private @Valid User user = null;

  /**
   **/
  public TeamPermission team(Team team) {
    this.team = team;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("team")
  public Team getTeam() {
    return team;
  }
  public void setTeam(Team team) {
    this.team = team;
  }

  /**
   **/
  public TeamPermission type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public TeamPermission permission(PermissionEnum permission) {
    this.permission = permission;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("permission")
  public PermissionEnum getPermission() {
    return permission;
  }
  public void setPermission(PermissionEnum permission) {
    this.permission = permission;
  }

  /**
   **/
  public TeamPermission user(User user) {
    this.user = user;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("user")
  public User getUser() {
    return user;
  }
  public void setUser(User user) {
    this.user = user;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TeamPermission teamPermission = (TeamPermission) o;
    return Objects.equals(team, teamPermission.team) &&
        Objects.equals(type, teamPermission.type) &&
        Objects.equals(permission, teamPermission.permission) &&
        Objects.equals(user, teamPermission.user);
  }

  @Override
  public int hashCode() {
    return Objects.hash(team, type, permission, user);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TeamPermission {\n");
    
    sb.append("    team: ").append(toIndentedString(team)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    permission: ").append(toIndentedString(permission)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

