package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Base type for most resource objects. It defines the common &#x60;type&#x60; element that identifies an object&#39;s type. It also identifies the element as Swagger&#39;s &#x60;discriminator&#x60;.
 **/
@ApiModel(description = "Base type for most resource objects. It defines the common `type` element that identifies an object's type. It also identifies the element as Swagger's `discriminator`.")
public class Treeentry   {
  
  private @Valid String path;
  private @Valid Commit commit = null;
  private @Valid String type;

  /**
   * The path in the repository
   **/
  public Treeentry path(String path) {
    this.path = path;
    return this;
  }

  
  @ApiModelProperty(value = "The path in the repository")
  @JsonProperty("path")
  public String getPath() {
    return path;
  }
  public void setPath(String path) {
    this.path = path;
  }

  /**
   **/
  public Treeentry commit(Commit commit) {
    this.commit = commit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("commit")
  public Commit getCommit() {
    return commit;
  }
  public void setCommit(Commit commit) {
    this.commit = commit;
  }

  /**
   **/
  public Treeentry type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Treeentry treeentry = (Treeentry) o;
    return Objects.equals(path, treeentry.path) &&
        Objects.equals(commit, treeentry.commit) &&
        Objects.equals(type, treeentry.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, commit, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Treeentry {\n");
    
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    commit: ").append(toIndentedString(commit)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

