package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class User extends Account  {
  
  private @Valid String accountId;
  private @Valid Boolean isStaff;

  /**
   * The user&#39;s Atlassian account ID.
   **/
  public User accountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  
  @ApiModelProperty(value = "The user's Atlassian account ID.")
  @JsonProperty("account_id")
  public String getAccountId() {
    return accountId;
  }
  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  /**
   **/
  public User isStaff(Boolean isStaff) {
    this.isStaff = isStaff;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("is_staff")
  public Boolean getIsStaff() {
    return isStaff;
  }
  public void setIsStaff(Boolean isStaff) {
    this.isStaff = isStaff;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(accountId, user.accountId) &&
        Objects.equals(isStaff, user.isStaff);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, isStaff);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    isStaff: ").append(toIndentedString(isStaff)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

