package se.bjurr.bitbucketcloud.gen.api;

import se.bjurr.bitbucketcloud.gen.model.Error;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/addon")
@Api(description = "the addon API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2020-02-02T18:59:26.878+01:00[Europe/Stockholm]")
public interface AddonApi {

    @DELETE
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonDelete();

    @GET
    @Path("/linkers")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersGet();

    @GET
    @Path("/linkers/{linker_key}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyGet(@PathParam("linker_key") String linkerKey);

    @DELETE
    @Path("/linkers/{linker_key}/values")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyValuesDelete(@PathParam("linker_key") String linkerKey);

    @DELETE
    @Path("/linkers/{linker_key}/values/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyValuesDelete_1(@PathParam("linker_key") String linkerKey);

    @GET
    @Path("/linkers/{linker_key}/values")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyValuesGet(@PathParam("linker_key") String linkerKey);

    @GET
    @Path("/linkers/{linker_key}/values/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyValuesGet_2(@PathParam("linker_key") String linkerKey);

    @POST
    @Path("/linkers/{linker_key}/values")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyValuesPost(@PathParam("linker_key") String linkerKey);

    @PUT
    @Path("/linkers/{linker_key}/values")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonLinkersLinkerKeyValuesPut(@PathParam("linker_key") String linkerKey);

    @PUT
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error addonPut();

    @POST
    @Path("/users/{target_user}/events/{event_key}")
    @ApiOperation(value = "", notes = "POST a new custom event.  The data within the event body will be hydrated by Bitbucket. For example, the following event submission would result in subscribers for the event receiving the full repository object corresponding to the UUID.  ``` $ curl -X POST -H \"Content-Type: application/json\" -d '{     \"mynumdata\": \"12345\",     \"repository\": {         \"type\": \"repository\",         \"uuid\": \"{be95aa1f-c0b2-47f6-99d1-bf5d3a0f850f}\" }}' https://api.bitbucket.org/2.0/addon/users/myuser/events/com.example.app%3Amyevent ```  Use the optional `fields` property of the custom event Connect module where the event is defined to add additional fields to the expanded payload sent to listeners.  For example, the `customEvents` module in the app descriptor for the previous example would look like this:  ``` 'modules': {     'customEvents': {         'com.example.app:myevent': {             'schema': {                 'properties': {                     'mynumdata': {'type': 'number'},                     'repository': {'$ref': '#/definitions/repository'}                 }             },             'fields': ['repository.owner']         }     } } ```  By specifying fields as above, the repository owner will also be sent to subscribers of the event.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "addon" })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "Event successfully submitted", response = Void.class),
        @ApiResponse(code = 404, message = "Connect app not installed or event does not exist", response = Void.class) })
    void addonUsersTargetUserEventsEventKeyPost(@PathParam("target_user") @ApiParam("The account the app is installed in.  This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String targetUser,@PathParam("event_key") @ApiParam("The key of the event, which corresponds to an event defined in the connect app descriptor. ") String eventKey);
}
