package se.bjurr.bitbucketcloud.gen.api;

import se.bjurr.bitbucketcloud.gen.model.Error;
import se.bjurr.bitbucketcloud.gen.model.PaginatedHookEvents;
import se.bjurr.bitbucketcloud.gen.model.SubjectTypes;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/hook_events")
@Api(description = "the hook_events API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2020-02-02T18:59:26.878+01:00[Europe/Stockholm]")
public interface HookEventsApi {

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the webhook resource or subject types on which webhooks can be registered.  Each resource/subject type contains an `events` link that returns the paginated list of specific events each individual subject type can emit.  This endpoint is publicly accessible and does not require authentication or scopes.  Example:  ``` $ curl https://api.bitbucket.org/2.0/hook_events  {     \"repository\": {         \"links\": {             \"events\": {                 \"href\": \"https://api.bitbucket.org/2.0/hook_events/repository\"             }         }     },     \"team\": {         \"links\": {             \"events\": {                 \"href\": \"https://api.bitbucket.org/2.0/hook_events/team\"             }         }     },     \"user\": {         \"links\": {             \"events\": {                 \"href\": \"https://api.bitbucket.org/2.0/hook_events/user\"             }         }     } } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "webhooks",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A mapping of resource/subject types pointing to their individual event types.", response = SubjectTypes.class) })
    SubjectTypes hookEventsGet();

    @GET
    @Path("/{subject_type}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns a paginated list of all valid webhook events for the specified entity.  This is public data that does not require any scopes or authentication.  Example:  NOTE: The following example is a truncated response object for the `team` `subject_type`. We return the same structure for the other `subject_type` objects.  ``` $ curl https://api.bitbucket.org/2.0/hook_events/team {     \"page\": 1,     \"pagelen\": 30,     \"size\": 21,     \"values\": [         {             \"category\": \"Repository\",             \"description\": \"Whenever a repository push occurs\",             \"event\": \"repo:push\",             \"label\": \"Push\"         },         {             \"category\": \"Repository\",             \"description\": \"Whenever a repository fork occurs\",             \"event\": \"repo:fork\",             \"label\": \"Fork\"         },         ...         {             \"category\": \"Repository\",             \"description\": \"Whenever a repository import occurs\",             \"event\": \"repo:imported\",             \"label\": \"Import\"         }     ] } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "webhooks" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of webhook types available to subscribe on.", response = PaginatedHookEvents.class),
        @ApiResponse(code = 404, message = "If an invalid `{subject_type}` value was specified.", response = Error.class) })
    PaginatedHookEvents hookEventsSubjectTypeGet(@PathParam("subject_type") @ApiParam("A resource or subject type.") String subjectType);
}
