package se.bjurr.bitbucketcloud.gen.api;

import se.bjurr.bitbucketcloud.gen.model.Error;
import se.bjurr.bitbucketcloud.gen.model.PaginatedPullrequests;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/pullrequests")
@Api(description = "the pullrequests API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2020-02-02T18:59:26.878+01:00[Europe/Stockholm]")
public interface PullrequestsApi {

    @GET
    @Path("/{target_user}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns all pull requests authored by the specified user.  By default only open pull requests are returned. This can be controlled using the `state` query parameter. To retrieve pull requests that are in one of multiple states, repeat the `state` parameter for each individual state.  This endpoint also supports filtering and sorting of the results. See [filtering and sorting](../../../../meta/filtering) for more details.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "pullrequests" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "All pull requests authored by the specified user.", response = PaginatedPullrequests.class),
        @ApiResponse(code = 404, message = "If the specified user does not exist.", response = Error.class) })
    PaginatedPullrequests pullrequestsTargetUserGet(@PathParam("target_user") String targetUser,@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@QueryParam("state")   @ApiParam("Only return pull requests that are in this state. This parameter can be repeated.")  String state);
}
