package se.bjurr.bitbucketcloud.gen.api;

import se.bjurr.bitbucketcloud.gen.model.Error;
import se.bjurr.bitbucketcloud.gen.model.PaginatedPipelineVariables;
import se.bjurr.bitbucketcloud.gen.model.PaginatedProjects;
import se.bjurr.bitbucketcloud.gen.model.PaginatedRepositoryPermissions;
import se.bjurr.bitbucketcloud.gen.model.PaginatedTeamPermissions;
import se.bjurr.bitbucketcloud.gen.model.PaginatedTeams;
import se.bjurr.bitbucketcloud.gen.model.PaginatedUsers;
import se.bjurr.bitbucketcloud.gen.model.PaginatedWebhookSubscriptions;
import se.bjurr.bitbucketcloud.gen.model.PipelineVariable;
import se.bjurr.bitbucketcloud.gen.model.Project;
import se.bjurr.bitbucketcloud.gen.model.SearchResultPage;
import se.bjurr.bitbucketcloud.gen.model.Team;
import se.bjurr.bitbucketcloud.gen.model.User;
import se.bjurr.bitbucketcloud.gen.model.WebhookSubscription;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/teams")
@Api(description = "the teams API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2020-02-02T18:59:26.878+01:00[Europe/Stockholm]")
public interface TeamsApi {

    @POST
    @Path("/{username}/pipelines_config/variables/")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Create an account level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "The created variable.", response = PipelineVariable.class),
        @ApiResponse(code = 404, message = "The account does not exist.", response = Error.class),
        @ApiResponse(code = 409, message = "A variable with the provided key already exists.", response = Error.class) })
    PipelineVariable createPipelineVariableForTeam(@PathParam("username") @ApiParam("The account.") String username,@Valid PipelineVariable pipelineVariable);

    @DELETE
    @Path("/{username}/pipelines_config/variables/{variable_uuid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Delete a team level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "The variable was deleted", response = Void.class),
        @ApiResponse(code = 404, message = "The account or the variable with the provided UUID does not exist.", response = Error.class) })
    void deletePipelineVariableForTeam(@PathParam("username") @ApiParam("The account.") String username,@PathParam("variable_uuid") @ApiParam("The UUID of the variable to delete.") String variableUuid);

    @GET
    @Path("/{username}/pipelines_config/variables/{variable_uuid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Retrieve a team level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The variable.", response = PipelineVariable.class),
        @ApiResponse(code = 404, message = "The account or variable with the given UUID was not found.", response = Error.class) })
    PipelineVariable getPipelineVariableForTeam(@PathParam("username") @ApiParam("The account.") String username,@PathParam("variable_uuid") @ApiParam("The UUID of the variable to retrieve.") String variableUuid);

    @GET
    @Path("/{username}/pipelines_config/variables/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Find account level variables.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The found account level variables.", response = PaginatedPipelineVariables.class) })
    PaginatedPipelineVariables getPipelineVariablesForTeam(@PathParam("username") @ApiParam("The account.") String username);

    @GET
    @Path("/{username}/search/code")
    @Produces({ "application/json" })
    @ApiOperation(value = "Search for code in the repositories of the specified team", notes = "", tags={ "search",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Successful search", response = SearchResultPage.class),
        @ApiResponse(code = 400, message = "If the search request was invalid due to one of the following reasons: * the specified type of target account doesn't match the actual account type; * malformed pagination properties; * missing or malformed search query, in the latter case an error key will be returned in `error.data.key` property.", response = Error.class),
        @ApiResponse(code = 404, message = "Search is not enabled for the requested team, navigate to [https://bitbucket.org/search](https://bitbucket.org/search) to turn it on", response = Error.class),
        @ApiResponse(code = 429, message = "Too many requests, try again later", response = Error.class) })
    SearchResultPage searchAccount(@PathParam("username") @ApiParam("The account to search in; either the username or the UUID in curly braces") String username,@QueryParam("search_query") @NotNull   @ApiParam("The search query")  String searchQuery,@QueryParam("page")  @DefaultValue("1")  @ApiParam("Which page of the search results to retrieve")  Integer page,@QueryParam("pagelen")  @DefaultValue("10")  @ApiParam("How many search results to retrieve per page")  Integer pagelen);

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns all the teams that the authenticated user is associated with.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of teams.", response = PaginatedTeams.class),
        @ApiResponse(code = 401, message = "When the request wasn't authenticated.", response = Error.class) })
    PaginatedTeams teamsGet(@QueryParam("role")   @ApiParam(" Filters the teams based on the authenticated user&#39;s role on each team.  * **member**: returns a list of all the teams which the caller is a member of   at least one team group or repository owned by the team * **contributor**: returns a list of teams which the caller has write access   to at least one repository owned by the team * **admin**: returns a list teams which the caller has team administrator access ")  String role);

    @GET
    @Path("/{username}/followers")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the list of accounts that are following this team.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of user objects.", response = PaginatedUsers.class),
        @ApiResponse(code = 404, message = "If no team exists for the specified name, or if the specified account is a personal account, not a team account.", response = Error.class) })
    PaginatedUsers teamsUsernameFollowersGet(@PathParam("username") @ApiParam("The team&#39;s username") String username);

    @GET
    @Path("/{username}/following")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the list of accounts this team is following.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of user objects.", response = PaginatedUsers.class),
        @ApiResponse(code = 404, message = "If no team exists for the specified name, or if the specified account is a personal account, not a team account.", response = Error.class) })
    PaginatedUsers teamsUsernameFollowingGet(@PathParam("username") @ApiParam("The team&#39;s username") String username);

    @GET
    @Path("/{username}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Gets the public information associated with a team.  If the team's profile is private, `location`, `website` and `created_on` elements are omitted.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The team object", response = Team.class),
        @ApiResponse(code = 404, message = "If no team exists for the specified name or UUID, or if the specified account is a personal account, not a team account.", response = Error.class) })
    Team teamsUsernameGet(@PathParam("username") @ApiParam("The team&#39;s username or UUID.") String username);

    @GET
    @Path("/{username}/hooks")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns a paginated list of webhooks installed on this team.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The paginated list of installed webhooks.", response = PaginatedWebhookSubscriptions.class),
        @ApiResponse(code = 403, message = "If the authenticated user is not an admin on the specified team.", response = Error.class),
        @ApiResponse(code = 404, message = "If the specified team does not exist.", response = Error.class) })
    PaginatedWebhookSubscriptions teamsUsernameHooksGet(@PathParam("username") String username);

    @POST
    @Path("/{username}/hooks")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Creates a new webhook on the specified team.  Team webhooks are fired for events from all repositories belonging to that team account.  Note that only admins can install webhooks on teams.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "The newly installed webhook.", response = WebhookSubscription.class),
        @ApiResponse(code = 403, message = "If the authenticated user is not an admin on the specified team.", response = Error.class),
        @ApiResponse(code = 404, message = "If the specified team does not exist.", response = Error.class) })
    WebhookSubscription teamsUsernameHooksPost(@PathParam("username") String username);

    @DELETE
    @Path("/{username}/hooks/{uid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Deletes the specified webhook subscription from the given team account.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "When the webhook was deleted successfully", response = Void.class),
        @ApiResponse(code = 403, message = "If the authenticated user does not have permission to delete the webhook.", response = Error.class),
        @ApiResponse(code = 404, message = "If the webhook or team does not exist.", response = Error.class) })
    void teamsUsernameHooksUidDelete(@PathParam("username") String username,@PathParam("uid") @ApiParam("The installed webhook&#39;s id") String uid);

    @GET
    @Path("/{username}/hooks/{uid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the webhook with the specified id installed on the given team account.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The webhook subscription object.", response = WebhookSubscription.class),
        @ApiResponse(code = 404, message = "If the webhook or team does not exist.", response = Error.class) })
    WebhookSubscription teamsUsernameHooksUidGet(@PathParam("username") String username,@PathParam("uid") @ApiParam("The installed webhook&#39;s id.") String uid);

    @PUT
    @Path("/{username}/hooks/{uid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Updates the specified webhook subscription.  The following properties can be mutated:  * `description` * `url` * `active` * `events`", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The webhook subscription object.", response = WebhookSubscription.class),
        @ApiResponse(code = 403, message = "If the authenticated user does not have permission to update the webhook.", response = Error.class),
        @ApiResponse(code = 404, message = "If the webhook or team does not exist.", response = Error.class) })
    WebhookSubscription teamsUsernameHooksUidPut(@PathParam("username") String username,@PathParam("uid") @ApiParam("The installed webhook&#39;s id") String uid);

    @GET
    @Path("/{username}/members")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns all members of the specified team. Any member of any of the team's groups is considered a member of the team. This includes users in groups that may not actually have access to any of the team's repositories.  This operation has been deprecated due to privacy changes. See the [announcement](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/) for details.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "All members", response = User.class),
        @ApiResponse(code = 404, message = "When the team does not exist, or multiple teams with the same name exist that differ only in casing and the URL did not match the exact casing of a particular one.", response = Error.class) })
    User teamsUsernameMembersGet(@PathParam("username") String username);

    @GET
    @Path("/{username}/permissions")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns an object for each team permission a user on the team has.  Permissions returned are effective permissions â if a user is a member of multiple groups with distinct roles, only the highest level is returned.  Permissions can be:  * `admin` * `collaborator`  Only users with admin permission for the team may access this resource.  Example:  ``` $ curl https://api.bitbucket.org/2.0/teams/atlassian_tutorial/permissions  {   \"pagelen\": 10,   \"values\": [     {       \"permission\": \"admin\",       \"type\": \"team_permission\",       \"user\": {         \"type\": \"user\",         \"username\": \"evzijst\",         \"nickname\": \"evzijst\",         \"display_name\": \"Erik van Zijst\",         \"uuid\": \"{d301aafa-d676-4ee0-88be-962be7417567}\"       },       \"team\": {         \"username\": \"bitbucket\",         \"display_name\": \"Atlassian Bitbucket\",         \"uuid\": \"{4cc6108a-a241-4db0-96a5-64347ac04f87}\"       }     },     {       \"permission\": \"collaborator\",       \"type\": \"team_permission\",       \"user\": {         \"type\": \"user\",         \"username\": \"seanaty\",         \"nickname\": \"seanaty\",         \"display_name\": \"Sean Conaty\",         \"uuid\": \"{504c3b62-8120-4f0c-a7bc-87800b9d6f70}\"       },       \"team\": {         \"username\": \"bitbucket\",         \"display_name\": \"Atlassian Bitbucket\",         \"uuid\": \"{4cc6108a-a241-4db0-96a5-64347ac04f87}\"       }     }   ],   \"page\": 1,   \"size\": 2 } ```  Results may be further [filtered or sorted](../../../meta/filtering) by team, user, or permission by adding the following query string parameters:  * `q=user.username=\"evzijst\"` or `q=permission=\"admin\"` * `sort=team.display_name`  Note that the query parameter values need to be URL escaped so that `=` would become `%3D`.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Repositories owned by a team.", response = PaginatedTeamPermissions.class),
        @ApiResponse(code = 403, message = "The requesting user isn't an admin of the team.", response = Error.class) })
    PaginatedTeamPermissions teamsUsernamePermissionsGet(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@QueryParam("q")   @ApiParam(" Query string to narrow down the response as per [filtering and sorting](../../../meta/filtering).")  String q,@QueryParam("sort")   @ApiParam(" Name of a response property sort the result by as per [filtering and sorting](../../../meta/filtering#query-sort). ")  String sort);

    @GET
    @Path("/{username}/permissions/repositories")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns an object for each repository permission for all of a teamâs repositories.  If the username URL parameter refers to a user account instead of a team account, an object containing the repository permissions of all the username's repositories will be returned.  Permissions returned are effective permissions â the highest level of permission the user has. This does not include public repositories that users are not granted any specific permission in, and does not distinguish between direct and indirect privileges.  Only users with admin permission for the team may access this resource.  Permissions can be:  * `admin` * `write` * `read`  Example:  ``` $ curl https://api.bitbucket.org/2.0/teams/atlassian_tutorial/permissions/repositories  {   \"pagelen\": 10,   \"values\": [     {       \"type\": \"repository_permission\",       \"user\": {         \"type\": \"user\",         \"username\": \"evzijst\",         \"display_name\": \"Erik van Zijst\",         \"uuid\": \"{d301aafa-d676-4ee0-88be-962be7417567}\"       },       \"repository\": {         \"type\": \"repository\",         \"name\": \"geordi\",         \"full_name\": \"bitbucket/geordi\",         \"uuid\": \"{85d08b4e-571d-44e9-a507-fa476535aa98}\"       },       \"permission\": \"admin\"     },     {       \"type\": \"repository_permission\",       \"user\": {         \"type\": \"user\",         \"username\": \"seanaty\",         \"display_name\": \"Sean Conaty\",         \"uuid\": \"{504c3b62-8120-4f0c-a7bc-87800b9d6f70}\"       },       \"repository\": {         \"type\": \"repository\",         \"name\": \"geordi\",         \"full_name\": \"bitbucket/geordi\",         \"uuid\": \"{85d08b4e-571d-44e9-a507-fa476535aa98}\"       },       \"permission\": \"write\"     }   ],   \"page\": 1,   \"size\": 2 } ```  Results may be further [filtered or sorted](../../../../meta/filtering) by repository, user, or permission by adding the following query string parameters:  * `q=repository.name=\"geordi\"` or `q=permission>\"read\"` * `sort=user.display_name`  Note that the query parameter values need to be URL escaped so that `=` would become `%3D`.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "List of team's repository permissions.", response = PaginatedRepositoryPermissions.class),
        @ApiResponse(code = 403, message = "The requesting user isn't an admin of the team.", response = Error.class) })
    PaginatedRepositoryPermissions teamsUsernamePermissionsRepositoriesGet(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@QueryParam("q")   @ApiParam(" Query string to narrow down the response as per [filtering and sorting](../../../../meta/filtering).")  String q,@QueryParam("sort")   @ApiParam(" Name of a response property sort the result by as per [filtering and sorting](../../../../meta/filtering#query-sort). ")  String sort);

    @GET
    @Path("/{username}/permissions/repositories/{repo_slug}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns an object for each repository permission of a given repository.  If the username URL parameter refers to a user account instead of a team account, an object containing the repository permissions of the username's repository will be returned.  Permissions returned are effective permissions â the highest level of permission the user has. This does not include public repositories that users are not granted any specific permission in, and does not distinguish between direct and indirect privileges.  Only users with admin permission for the repository may access this resource.  Permissions can be:  * `admin` * `write` * `read`  Example:  ``` $ curl https://api.bitbucket.org/2.0/teams/atlassian_tutorial/permissions/repositories/geordi  {   \"pagelen\": 10,   \"values\": [     {       \"type\": \"repository_permission\",       \"user\": {         \"type\": \"user\",         \"username\": \"evzijst\",         \"display_name\": \"Erik van Zijst\",         \"uuid\": \"{d301aafa-d676-4ee0-88be-962be7417567}\"       },       \"repository\": {         \"type\": \"repository\",         \"name\": \"geordi\",         \"full_name\": \"bitbucket/geordi\",         \"uuid\": \"{85d08b4e-571d-44e9-a507-fa476535aa98}\"       },       \"permission\": \"admin\"     },     {       \"type\": \"repository_permission\",       \"user\": {         \"type\": \"user\",         \"username\": \"seanaty\",         \"display_name\": \"Sean Conaty\",         \"uuid\": \"{504c3b62-8120-4f0c-a7bc-87800b9d6f70}\"       },       \"repository\": {         \"type\": \"repository\",         \"name\": \"geordi\",         \"full_name\": \"bitbucket/geordi\",         \"uuid\": \"{85d08b4e-571d-44e9-a507-fa476535aa98}\"       },       \"permission\": \"write\"     }   ],   \"page\": 1,   \"size\": 2 } ```  Results may be further [filtered or sorted](../../../../meta/filtering) by user, or permission by adding the following query string parameters:  * `q=permission>\"read\"` * `sort=user.display_name`  Note that the query parameter values need to be URL escaped so that `=` would become `%3D`.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "List of repository's repository permissions.", response = PaginatedRepositoryPermissions.class),
        @ApiResponse(code = 403, message = "The requesting user isn't an admin of the repository.", response = Error.class) })
    PaginatedRepositoryPermissions teamsUsernamePermissionsRepositoriesRepoSlugGet(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@PathParam("repo_slug") @ApiParam("This can either be the repository slug or the UUID of the repository, surrounded by curly-braces, for example: &#x60;{repository UUID}&#x60;. ") String repoSlug,@QueryParam("q")   @ApiParam(" Query string to narrow down the response as per [filtering and sorting](../../../../meta/filtering).")  String q,@QueryParam("sort")   @ApiParam(" Name of a response property sort the result by as per [filtering and sorting](../../../../meta/filtering#query-sort). ")  String sort);

    @GET
    @Path("/{username}/projects/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "projects",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of projects that belong to the specified team.", response = PaginatedProjects.class),
        @ApiResponse(code = 403, message = "The requesting user isn't authorized to read the list of projects for the specified team.", response = Error.class),
        @ApiResponse(code = 404, message = "A team doesn't exist at this location.", response = Error.class) })
    PaginatedProjects teamsUsernameProjectsGet(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username);

    @POST
    @Path("/{username}/projects/")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Creates a new project.  Note that the avatar has to be embedded as either a data-url or a URL to an external image as shown in the examples below:  ``` $ body=$(cat << EOF {     \"name\": \"Mars Project\",     \"key\": \"MARS\",     \"description\": \"Software for colonizing mars.\",     \"links\": {         \"avatar\": {             \"href\": \"data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/...\"         }     },     \"is_private\": false } EOF ) $ curl -H \"Content-Type: application/json\" \\        -X POST \\        -d \"$body\" \\        https://api.bitbucket.org/2.0/teams/teams-in-space/projects/ | jq . {   // Serialized project document } ```  or even:  ``` $ body=$(cat << EOF {     \"name\": \"Mars Project\",     \"key\": \"MARS\",     \"description\": \"Software for colonizing mars.\",     \"links\": {         \"avatar\": {             \"href\": \"http://i.imgur.com/72tRx4w.gif\"         }     },     \"is_private\": false } EOF ) $ curl -H \"Content-Type: application/json\" \\        -X POST \\        -d \"$body\" \\        https://api.bitbucket.org/2.0/teams/teams-in-space/projects/ | jq . {   // Serialized project document } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "projects",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "A new project has been created.", response = Project.class),
        @ApiResponse(code = 403, message = "The requesting user isn't authorized to create the project.", response = Error.class),
        @ApiResponse(code = 404, message = "A team doesn't exist at this location.", response = Error.class) })
    Project teamsUsernameProjectsPost(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@Valid Project project);

    @DELETE
    @Path("/{username}/projects/{project_key}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "projects",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "Successful deletion.", response = Void.class),
        @ApiResponse(code = 403, message = "The requesting user isn't authorized to delete the project or the project isn't empty.", response = Error.class),
        @ApiResponse(code = 404, message = "A project isn't hosted at this location.", response = Error.class) })
    void teamsUsernameProjectsProjectKeyDelete(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@PathParam("project_key") @ApiParam("The project in question. This can either be the actual &#x60;key&#x60; assigned to the project or the &#x60;UUID&#x60; (surrounded by curly-braces (&#x60;{}&#x60;)). ") String projectKey);

    @GET
    @Path("/{username}/projects/{project_key}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "projects",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The project object.", response = Project.class),
        @ApiResponse(code = 403, message = "The requesting user isn't authorized to access the project.", response = Error.class),
        @ApiResponse(code = 404, message = "A project isn't hosted at this location.", response = Error.class) })
    Project teamsUsernameProjectsProjectKeyGet(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@PathParam("project_key") @ApiParam("The project in question. This can either be the actual &#x60;key&#x60; assigned to the project or the &#x60;UUID&#x60; (surrounded by curly-braces (&#x60;{}&#x60;)). ") String projectKey);

    @PUT
    @Path("/{username}/projects/{project_key}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Since this endpoint can be used to both update and to create a project, the request body depends on the intent.  ### Creation  See the POST documentation for the project collection for an example of the request body.  Note: The `key` should not be specified in the body of request (since it is already present in the URL). The `name` is required, everything else is optional.  ### Update  See the POST documentation for the project collection for an example of the request body.  Note: The key is not required in the body (since it is already in the URL). The key may be specified in the body, if the intent is to change the key itself. In such a scenario, the location of the project is changed and is returned in the `Location` header of the response.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "projects",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The existing project is has been updated.", response = Project.class),
        @ApiResponse(code = 201, message = "A new project has been created.", response = Project.class),
        @ApiResponse(code = 403, message = "The requesting user isn't authorized to update or create the project.", response = Error.class),
        @ApiResponse(code = 404, message = "A team doesn't exist at the location. Note that the project's absence from this location doesn't raise a 404, since a PUT at a non-existent location can be used to create a new project.", response = Error.class) })
    Project teamsUsernameProjectsProjectKeyPut(@PathParam("username") @ApiParam("This can either be the username or the UUID of the account, surrounded by curly-braces, for example: &#x60;{account UUID}&#x60;. An account is either a team or user. ") String username,@PathParam("project_key") @ApiParam("The project in question. This can either be the actual &#x60;key&#x60; assigned to the project or the &#x60;UUID&#x60; (surrounded by curly-braces (&#x60;{}&#x60;)). ") String projectKey,@Valid Project project);

    @GET
    @Path("/{username}/repositories")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "All repositories owned by a user/team. This includes private repositories, but filtered down to the ones that the calling user has access to.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error teamsUsernameRepositoriesGet(@PathParam("username") String username);

    @PUT
    @Path("/{username}/pipelines_config/variables/{variable_uuid}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Update a team level variable.", tags={ "pipelines" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The variable was updated.", response = PipelineVariable.class),
        @ApiResponse(code = 404, message = "The account or the variable was not found.", response = Error.class) })
    PipelineVariable updatePipelineVariableForTeam(@PathParam("username") @ApiParam("The account.") String username,@PathParam("variable_uuid") @ApiParam("The UUID of the variable.") String variableUuid,@Valid PipelineVariable pipelineVariable);
}
