package se.bjurr.bitbucketcloud.gen.api;

import se.bjurr.bitbucketcloud.gen.model.Error;
import se.bjurr.bitbucketcloud.gen.model.PaginatedPipelineVariables;
import se.bjurr.bitbucketcloud.gen.model.PaginatedSshUserKeys;
import se.bjurr.bitbucketcloud.gen.model.PaginatedUsers;
import se.bjurr.bitbucketcloud.gen.model.PaginatedWebhookSubscriptions;
import se.bjurr.bitbucketcloud.gen.model.PipelineVariable;
import se.bjurr.bitbucketcloud.gen.model.SearchResultPage;
import se.bjurr.bitbucketcloud.gen.model.SshAccountKey;
import se.bjurr.bitbucketcloud.gen.model.User;
import se.bjurr.bitbucketcloud.gen.model.WebhookSubscription;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/users")
@Api(description = "the users API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2020-02-02T18:59:26.878+01:00[Europe/Stockholm]")
public interface UsersApi {

    @POST
    @Path("/{username}/pipelines_config/variables/")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Create a user level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "The created variable.", response = PipelineVariable.class),
        @ApiResponse(code = 404, message = "The account does not exist.", response = Error.class),
        @ApiResponse(code = 409, message = "A variable with the provided key already exists.", response = Error.class) })
    PipelineVariable createPipelineVariableForUser(@PathParam("username") @ApiParam("The account.") String username,@Valid PipelineVariable pipelineVariable);

    @DELETE
    @Path("/{username}/pipelines_config/variables/{variable_uuid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Delete an account level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "The variable was deleted", response = Void.class),
        @ApiResponse(code = 404, message = "The account or the variable with the provided UUID does not exist.", response = Error.class) })
    void deletePipelineVariableForUser(@PathParam("username") @ApiParam("The account.") String username,@PathParam("variable_uuid") @ApiParam("The UUID of the variable to delete.") String variableUuid);

    @DELETE
    @Path("/{username}/properties/{app_key}/{property_name}")
    @ApiOperation(value = "", notes = "Delete an application property value stored against a user.", tags={ "properties",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "An empty response.", response = Void.class) })
    void deleteUserHostedPropertyValue(@PathParam("username") @ApiParam("The user.") String username,@PathParam("app_key") @ApiParam("The key of the Connect app.") String appKey,@PathParam("property_name") @ApiParam("The name of the property.") String propertyName);

    @GET
    @Path("/{username}/pipelines_config/variables/{variable_uuid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Retrieve a user level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The variable.", response = PipelineVariable.class),
        @ApiResponse(code = 404, message = "The account or variable with the given UUID was not found.", response = Error.class) })
    PipelineVariable getPipelineVariableForUser(@PathParam("username") @ApiParam("The account.") String username,@PathParam("variable_uuid") @ApiParam("The UUID of the variable to retrieve.") String variableUuid);

    @GET
    @Path("/{username}/pipelines_config/variables/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Find user level variables.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The found user level variables.", response = PaginatedPipelineVariables.class) })
    PaginatedPipelineVariables getPipelineVariablesForUser(@PathParam("username") @ApiParam("The account.") String username);

    @GET
    @Path("/{username}/properties/{app_key}/{property_name}")
    @ApiOperation(value = "", notes = "Retrieve an application property value stored against a user.", tags={ "properties",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The value of the property.", response = Void.class) })
    void retrieveUserHostedPropertyValue(@PathParam("username") @ApiParam("The user.") String username,@PathParam("app_key") @ApiParam("The key of the Connect app.") String appKey,@PathParam("property_name") @ApiParam("The name of the property.") String propertyName);

    @GET
    @Path("/{username}/search/code")
    @Produces({ "application/json" })
    @ApiOperation(value = "Search for code in the repositories of the specified user", notes = "", tags={ "search",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Successful search", response = SearchResultPage.class),
        @ApiResponse(code = 400, message = "If the search request was invalid due to one of the following reasons: * the specified type of target account doesn't match the actual account type; * malformed pagination properties; * missing or malformed search query, in the latter case an error key will be returned in `error.data.key` property.", response = Error.class),
        @ApiResponse(code = 404, message = "Search is not enabled for the requested user, navigate to [https://bitbucket.org/search](https://bitbucket.org/search) to turn it on", response = Error.class),
        @ApiResponse(code = 429, message = "Too many requests, try again later", response = Error.class) })
    SearchResultPage searchAccount(@PathParam("username") @ApiParam("The account to search in; either the username or the UUID in curly braces") String username,@QueryParam("search_query") @NotNull   @ApiParam("The search query")  String searchQuery,@QueryParam("page")  @DefaultValue("1")  @ApiParam("Which page of the search results to retrieve")  Integer page,@QueryParam("pagelen")  @DefaultValue("10")  @ApiParam("How many search results to retrieve per page")  Integer pagelen);

    @PUT
    @Path("/{username}/pipelines_config/variables/{variable_uuid}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Update a user level variable.", tags={ "pipelines",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The variable was updated.", response = PipelineVariable.class),
        @ApiResponse(code = 404, message = "The account or the variable was not found.", response = Error.class) })
    PipelineVariable updatePipelineVariableForUser(@PathParam("username") @ApiParam("The account.") String username,@PathParam("variable_uuid") @ApiParam("The UUID of the variable.") String variableUuid,@Valid PipelineVariable pipelineVariable);

    @PUT
    @Path("/{username}/properties/{app_key}/{property_name}")
    @ApiOperation(value = "", notes = "Update an application property value stored against a user.", tags={ "properties",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "An empty response.", response = Void.class) })
    void updateUserHostedPropertyValue(@PathParam("username") @ApiParam("The user.") String username,@PathParam("app_key") @ApiParam("The key of the Connect app.") String appKey,@PathParam("property_name") @ApiParam("The name of the property.") String propertyName);

    @GET
    @Path("/{username}/followers")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the list of accounts that are following this user.  This operation has been deprecated due to privacy changes. See the [announcement](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/) for details.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of user objects.", response = PaginatedUsers.class),
        @ApiResponse(code = 404, message = "If no account exists for the specified name, or if the specified account is a team account, not a personal account.", response = Error.class) })
    PaginatedUsers usersUsernameFollowersGet(@PathParam("username") @ApiParam("The account&#39;s username") String username);

    @GET
    @Path("/{username}/following")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the list of accounts this user is following.  This operation has been deprecated due to privacy changes. See the [announcement](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/) for details.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A paginated list of user objects.", response = PaginatedUsers.class),
        @ApiResponse(code = 404, message = "If no user exists for the specified name, or if the specified account is a team account, not a personal account.", response = Error.class) })
    PaginatedUsers usersUsernameFollowingGet(@PathParam("username") @ApiParam("The user&#39;s username") String username);

    @GET
    @Path("/{username}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Gets the public information associated with a user account.  If the user's profile is private, `location`, `website` and `created_on` elements are omitted.  Note that the user object returned by this operation is changing significantly, due to privacy changes. See the [announcement](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#changes-to-bitbucket-user-objects) for details.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The user object", response = User.class),
        @ApiResponse(code = 404, message = "If no user exists for the specified name or UUID, or if the specified account is a team account, not a personal account.", response = Error.class) })
    User usersUsernameGet(@PathParam("username") @ApiParam("The account&#39;s UUID, account_id, or username. Note that username has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis).") String username);

    @GET
    @Path("/{username}/hooks")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns a paginated list of webhooks installed on this user account.  Note that the username path parameter has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis). Use the account's UUID or account_id instead.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The paginated list of installed webhooks.", response = PaginatedWebhookSubscriptions.class),
        @ApiResponse(code = 403, message = "If the authenticated user is accessing an account other than their own.", response = Error.class),
        @ApiResponse(code = 404, message = "If the specified account does not exist.", response = Error.class) })
    PaginatedWebhookSubscriptions usersUsernameHooksGet(@PathParam("username") String username);

    @POST
    @Path("/{username}/hooks")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Creates a new webhook on the specified user account.  Account-level webhooks are fired for events from all repositories belonging to that account.  Note that one can only register webhooks on one's own account, not that of others.  Also, note that the username path parameter has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis). Use the account's UUID or account_id instead.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "The newly installed webhook.", response = WebhookSubscription.class),
        @ApiResponse(code = 403, message = "If the authenticated user is accessing an account other than their own.", response = Error.class),
        @ApiResponse(code = 404, message = "If the specified account does not exist.", response = Error.class) })
    WebhookSubscription usersUsernameHooksPost(@PathParam("username") String username);

    @DELETE
    @Path("/{username}/hooks/{uid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Deletes the specified webhook subscription from the given user account.  Note that the username path parameter has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis). Use the account's UUID or account_id instead.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "When the webhook was deleted successfully", response = Void.class),
        @ApiResponse(code = 403, message = "If the authenticated user does not have permission to delete the webhook.", response = Error.class),
        @ApiResponse(code = 404, message = "If the webhook or user does not exist.", response = Error.class) })
    void usersUsernameHooksUidDelete(@PathParam("username") String username,@PathParam("uid") @ApiParam("The installed webhook&#39;s id") String uid);

    @GET
    @Path("/{username}/hooks/{uid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns the webhook with the specified id installed on the given user account.  Note that the username path parameter has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis). Use the account's UUID or account_id instead.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The webhook subscription object.", response = WebhookSubscription.class),
        @ApiResponse(code = 404, message = "If the webhook or user does not exist.", response = Error.class) })
    WebhookSubscription usersUsernameHooksUidGet(@PathParam("username") String username,@PathParam("uid") @ApiParam("The installed webhook&#39;s id.") String uid);

    @PUT
    @Path("/{username}/hooks/{uid}")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Updates the specified webhook subscription.  The following properties can be mutated:  * `description` * `url` * `active` * `events`  Note that the username path parameter has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis). Use the account's UUID or account_id instead.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The webhook subscription object.", response = WebhookSubscription.class),
        @ApiResponse(code = 403, message = "If the authenticated user does not have permission to update the webhook.", response = Error.class),
        @ApiResponse(code = 404, message = "If the webhook or user does not exist.", response = Error.class) })
    WebhookSubscription usersUsernameHooksUidPut(@PathParam("username") String username,@PathParam("uid") @ApiParam("The installed webhook&#39;s id") String uid);

    @GET
    @Path("/{username}/members")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns all members of the specified team. Any member of any of the team's groups is considered a member of the team. This includes users in groups that may not actually have access to any of the team's repositories.  This operation has been deprecated due to privacy changes. See the [announcement](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/) for details.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "teams",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "All members", response = User.class),
        @ApiResponse(code = 404, message = "When the team does not exist, or multiple teams with the same name exist that differ only in casing and the URL did not match the exact casing of a particular one.", response = Error.class) })
    User usersUsernameMembersGet(@PathParam("username") String username);

    @GET
    @Path("/{username}/repositories")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "All repositories owned by a user/team. This includes private repositories, but filtered down to the ones that the calling user has access to.", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "users",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Unexpected error.", response = Error.class) })
    Error usersUsernameRepositoriesGet(@PathParam("username") String username);

    @DELETE
    @Path("/{username}/ssh-keys/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Deletes a specific SSH public key from a user's account  Example: ``` $ curl -X DELETE https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/{b15b6026-9c02-4626-b4ad-b905f99f763a} ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "ssh",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "The key has been deleted", response = Void.class),
        @ApiResponse(code = 400, message = "If the submitted key or related value is invalid", response = Error.class),
        @ApiResponse(code = 403, message = "If the current user does not have permission to add a key for the specified user", response = Void.class),
        @ApiResponse(code = 404, message = "If the specified user does not exist", response = Error.class) })
    void usersUsernameSshKeysDelete(@PathParam("username") @ApiParam("The account&#39;s username or UUID.") String username,@PathParam("key_id") @ApiParam("The SSH key&#39;s UUID value.") String keyId);

    @GET
    @Path("/{username}/ssh-keys/")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns a specific SSH public key belonging to a user.  Example: ``` $ curl https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/{fbe4bbab-f6f7-4dde-956b-5c58323c54b3}  {     \"comment\": \"user@myhost\",     \"created_on\": \"2018-03-14T13:17:05.196003+00:00\",     \"key\": \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIKqP3Cr632C2dNhhgKVcon4ldUSAeKiku2yP9O9/bDtY\",     \"label\": \"\",     \"last_used\": \"2018-03-20T13:18:05.196003+00:00\",     \"links\": {         \"self\": {             \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/b15b6026-9c02-4626-b4ad-b905f99f763a\"         }     },     \"owner\": {         \"display_name\": \"Mark Adams\",         \"links\": {             \"avatar\": {                 \"href\": \"https://bitbucket.org/account/markadams-atl/avatar/32/\"             },             \"html\": {                 \"href\": \"https://bitbucket.org/markadams-atl/\"             },             \"self\": {                 \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl\"             }         },         \"type\": \"user\",         \"username\": \"markadams-atl\",         \"nickname\": \"markadams-atl\",         \"uuid\": \"{d7dd0e2d-3994-4a50-a9ee-d260b6cefdab}\"     },     \"type\": \"ssh_key\",     \"uuid\": \"{b15b6026-9c02-4626-b4ad-b905f99f763a}\" } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "ssh",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The specific SSH key matching the user and UUID", response = SshAccountKey.class),
        @ApiResponse(code = 403, message = "If the specified user or key is not accessible to the current user", response = Void.class),
        @ApiResponse(code = 404, message = "If the specified user or key does not exist", response = Error.class) })
    SshAccountKey usersUsernameSshKeysGet(@PathParam("username") @ApiParam("The account&#39;s username or UUID.") String username,@PathParam("key_id") @ApiParam("The SSH key&#39;s UUID value.") String keyId);

    @GET
    @Path("/{username}/ssh-keys")
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Returns a paginated list of the user's SSH public keys.  Example:  ``` $ curl https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys {     \"page\": 1,     \"pagelen\": 10,     \"size\": 1,     \"values\": [         {             \"comment\": \"user@myhost\",             \"created_on\": \"2018-03-14T13:17:05.196003+00:00\",             \"key\": \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIKqP3Cr632C2dNhhgKVcon4ldUSAeKiku2yP9O9/bDtY\",             \"label\": \"\",             \"last_used\": \"2018-03-20T13:18:05.196003+00:00\",             \"links\": {                 \"self\": {                     \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/b15b6026-9c02-4626-b4ad-b905f99f763a\"                 }             },             \"owner\": {                 \"display_name\": \"Mark Adams\",                 \"links\": {                     \"avatar\": {                         \"href\": \"https://bitbucket.org/account/markadams-atl/avatar/32/\"                     },                     \"html\": {                         \"href\": \"https://bitbucket.org/markadams-atl/\"                     },                     \"self\": {                         \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl\"                     }                 },                 \"type\": \"user\",                 \"username\": \"markadams-atl\",                 \"nickname\": \"markadams-atl\",                 \"uuid\": \"{d7dd0e2d-3994-4a50-a9ee-d260b6cefdab}\"             },             \"type\": \"ssh_key\",             \"uuid\": \"{b15b6026-9c02-4626-b4ad-b905f99f763a}\"         }     ] } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "ssh",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "A list of the SSH keys associated with the account.", response = PaginatedSshUserKeys.class),
        @ApiResponse(code = 403, message = "If the specified user's keys are not accessible to the current user", response = Void.class),
        @ApiResponse(code = 404, message = "If the specified user does not exist", response = Error.class) })
    PaginatedSshUserKeys usersUsernameSshKeysGet_1(@PathParam("username") @ApiParam("The account&#39;s UUID, account_id, or username. Note that username has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis).") String username);

    @POST
    @Path("/{username}/ssh-keys")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Adds a new SSH public key to the specified user account and returns the resulting key.  Example: ``` $ curl -X POST -H \"Content-Type: application/json\" -d '{\"key\": \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIKqP3Cr632C2dNhhgKVcon4ldUSAeKiku2yP9O9/bDtY user@myhost\"}' https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys  {     \"comment\": \"user@myhost\",     \"created_on\": \"2018-03-14T13:17:05.196003+00:00\",     \"key\": \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIKqP3Cr632C2dNhhgKVcon4ldUSAeKiku2yP9O9/bDtY\",     \"label\": \"\",     \"last_used\": \"2018-03-20T13:18:05.196003+00:00\",     \"links\": {         \"self\": {             \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/b15b6026-9c02-4626-b4ad-b905f99f763a\"         }     },     \"owner\": {         \"display_name\": \"Mark Adams\",         \"links\": {             \"avatar\": {                 \"href\": \"https://bitbucket.org/account/markadams-atl/avatar/32/\"             },             \"html\": {                 \"href\": \"https://bitbucket.org/markadams-atl/\"             },             \"self\": {                 \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl\"             }         },         \"type\": \"user\",         \"username\": \"markadams-atl\",         \"nickname\": \"markadams-atl\",         \"uuid\": \"{d7dd0e2d-3994-4a50-a9ee-d260b6cefdab}\"     },     \"type\": \"ssh_key\",     \"uuid\": \"{b15b6026-9c02-4626-b4ad-b905f99f763a}\" } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "ssh",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "The newly created SSH key.", response = SshAccountKey.class),
        @ApiResponse(code = 400, message = "If the submitted key or related value is invalid", response = Error.class),
        @ApiResponse(code = 403, message = "If the current user does not have permission to add a key for the specified user", response = Void.class),
        @ApiResponse(code = 404, message = "If the specified user does not exist", response = Error.class) })
    SshAccountKey usersUsernameSshKeysPost(@PathParam("username") @ApiParam("The account&#39;s UUID, account_id, or username. Note that username has been deprecated due to [privacy changes](https://developer.atlassian.com/cloud/bitbucket/bitbucket-api-changes-gdpr/#removal-of-usernames-from-user-referencing-apis).") String username,@Valid SshAccountKey sshAccountKey);

    @PUT
    @Path("/{username}/ssh-keys/")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "", notes = "Updates a specific SSH public key on a user's account  Note: Only the 'comment' field can be updated using this API. To modify the key or comment values, you must delete and add the key again.  Example: ``` $ curl -X PUT -H \"Content-Type: application/json\" -d '{\"label\": \"Work key\"}' https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/{b15b6026-9c02-4626-b4ad-b905f99f763a}  {     \"comment\": \"\",     \"created_on\": \"2018-03-14T13:17:05.196003+00:00\",     \"key\": \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIKqP3Cr632C2dNhhgKVcon4ldUSAeKiku2yP9O9/bDtY\",     \"label\": \"Work key\",     \"last_used\": \"2018-03-20T13:18:05.196003+00:00\",     \"links\": {         \"self\": {             \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl/ssh-keys/b15b6026-9c02-4626-b4ad-b905f99f763a\"         }     },     \"owner\": {         \"display_name\": \"Mark Adams\",         \"links\": {             \"avatar\": {                 \"href\": \"https://bitbucket.org/account/markadams-atl/avatar/32/\"             },             \"html\": {                 \"href\": \"https://bitbucket.org/markadams-atl/\"             },             \"self\": {                 \"href\": \"https://api.bitbucket.org/2.0/users/markadams-atl\"             }         },         \"type\": \"user\",         \"username\": \"markadams-atl\",         \"nickname\": \"markadams-atl\",         \"uuid\": \"{d7dd0e2d-3994-4a50-a9ee-d260b6cefdab}\"     },     \"type\": \"ssh_key\",     \"uuid\": \"{b15b6026-9c02-4626-b4ad-b905f99f763a}\" } ```", authorizations = {
        @Authorization(value = "api_key"),
        @Authorization(value = "basic"),
        @Authorization(value = "oauth2", scopes = {
            @AuthorizationScope(scope = "email", description = "Read your account&#39;s primary email address"),
            @AuthorizationScope(scope = "project:write", description = "Read and modify your team&#39;s project settings, and read and transfer repositories within your team&#39;s projects"),
            @AuthorizationScope(scope = "account:write", description = "Read and modify your account information"),
            @AuthorizationScope(scope = "snippet:write", description = "Read and modify your snippets"),
            @AuthorizationScope(scope = "team:write", description = "Read and modify your team membership information"),
            @AuthorizationScope(scope = "issue:write", description = "Read and modify your repositories&#39; issues"),
            @AuthorizationScope(scope = "issue", description = "Read your repositories&#39; issues"),
            @AuthorizationScope(scope = "wiki", description = "Read and modify your repositories&#39; wikis"),
            @AuthorizationScope(scope = "pipeline:variable", description = "Access your repositories&#39; build pipelines and configure their variables"),
            @AuthorizationScope(scope = "pullrequest:write", description = "Read and modify your repositories and their pull requests"),
            @AuthorizationScope(scope = "pipeline:write", description = "Access and rerun your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "webhook", description = "Read and modify your repositories&#39; webhooks"),
            @AuthorizationScope(scope = "team", description = "Read your team membership information"),
            @AuthorizationScope(scope = "pipeline", description = "Access your repositories&#39; build pipelines"),
            @AuthorizationScope(scope = "repository:admin", description = "Administer your repositories"),
            @AuthorizationScope(scope = "repository:write", description = "Read and modify your repositories"),
            @AuthorizationScope(scope = "project", description = "Read your team&#39;s project settings and read repositories contained within your team&#39;s projects"),
            @AuthorizationScope(scope = "pullrequest", description = "Read your repositories and their pull requests"),
            @AuthorizationScope(scope = "repository:delete", description = "Delete your repositories"),
            @AuthorizationScope(scope = "repository", description = "Read your repositories"),
            @AuthorizationScope(scope = "account", description = "Read your account information"),
            @AuthorizationScope(scope = "snippet", description = "Read your snippets")
        })
    }, tags={ "ssh" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The newly updated SSH key.", response = SshAccountKey.class),
        @ApiResponse(code = 400, message = "If the submitted key or related value is invalid", response = Error.class),
        @ApiResponse(code = 403, message = "If the current user does not have permission to add a key for the specified user", response = Void.class),
        @ApiResponse(code = 404, message = "If the specified user does not exist", response = Error.class) })
    SshAccountKey usersUsernameSshKeysPut(@PathParam("username") @ApiParam("The account&#39;s username or UUID.") String username,@PathParam("key_id") @ApiParam("The SSH key&#39;s UUID value.") String keyId,@Valid SshAccountKey sshAccountKey);
}
