package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Account extends Object  {
  
  private @Valid String displayName;
  private @Valid Date createdOn;
  private @Valid String website;
  private @Valid Boolean has2faEnabled;
  private @Valid String username;
  private @Valid String uuid;
  private @Valid String nickname;
  private @Valid Object links = null;
  private @Valid String accountStatus;

  /**
   **/
  public Account displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("display_name")
  public String getDisplayName() {
    return displayName;
  }
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  /**
   **/
  public Account createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public Account website(String website) {
    this.website = website;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("website")
  public String getWebsite() {
    return website;
  }
  public void setWebsite(String website) {
    this.website = website;
  }

  /**
   **/
  public Account has2faEnabled(Boolean has2faEnabled) {
    this.has2faEnabled = has2faEnabled;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("has_2fa_enabled")
  public Boolean getHas2faEnabled() {
    return has2faEnabled;
  }
  public void setHas2faEnabled(Boolean has2faEnabled) {
    this.has2faEnabled = has2faEnabled;
  }

  /**
   **/
  public Account username(String username) {
    this.username = username;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("username")
 @Pattern(regexp="^[a-zA-Z0-9_\\-]+$")  public String getUsername() {
    return username;
  }
  public void setUsername(String username) {
    this.username = username;
  }

  /**
   **/
  public Account uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   * Account name defined by the owner. Should be used instead of the \&quot;username\&quot; field. Note that \&quot;nickname\&quot; cannot be used in place of \&quot;username\&quot; in URLs and queries, as \&quot;nickname\&quot; is not guaranteed to be unique.
   **/
  public Account nickname(String nickname) {
    this.nickname = nickname;
    return this;
  }

  
  @ApiModelProperty(value = "Account name defined by the owner. Should be used instead of the \"username\" field. Note that \"nickname\" cannot be used in place of \"username\" in URLs and queries, as \"nickname\" is not guaranteed to be unique.")
  @JsonProperty("nickname")
  public String getNickname() {
    return nickname;
  }
  public void setNickname(String nickname) {
    this.nickname = nickname;
  }

  /**
   **/
  public Account links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * The status of the account. Currently the only possible value is \&quot;active\&quot;, but more values may be added in the future.
   **/
  public Account accountStatus(String accountStatus) {
    this.accountStatus = accountStatus;
    return this;
  }

  
  @ApiModelProperty(value = "The status of the account. Currently the only possible value is \"active\", but more values may be added in the future.")
  @JsonProperty("account_status")
  public String getAccountStatus() {
    return accountStatus;
  }
  public void setAccountStatus(String accountStatus) {
    this.accountStatus = accountStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(displayName, account.displayName) &&
        Objects.equals(createdOn, account.createdOn) &&
        Objects.equals(website, account.website) &&
        Objects.equals(has2faEnabled, account.has2faEnabled) &&
        Objects.equals(username, account.username) &&
        Objects.equals(uuid, account.uuid) &&
        Objects.equals(nickname, account.nickname) &&
        Objects.equals(links, account.links) &&
        Objects.equals(accountStatus, account.accountStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayName, createdOn, website, has2faEnabled, username, uuid, nickname, links, accountStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("    has2faEnabled: ").append(toIndentedString(has2faEnabled)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    nickname: ").append(toIndentedString(nickname)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    accountStatus: ").append(toIndentedString(accountStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

