package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Author;
import se.bjurr.bitbucketcloud.gen.model.BaseCommit;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class BaseCommit extends Object  {
  
  private @Valid List<BaseCommit> parents = new ArrayList<BaseCommit>();
  private @Valid Date date;
  private @Valid String message;
  private @Valid Object summary = null;
  private @Valid Author author = null;
  private @Valid String hash;

  /**
   **/
  public BaseCommit parents(List<BaseCommit> parents) {
    this.parents = parents;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("parents")
 @Size(min=0)  public List<BaseCommit> getParents() {
    return parents;
  }
  public void setParents(List<BaseCommit> parents) {
    this.parents = parents;
  }

  /**
   **/
  public BaseCommit date(Date date) {
    this.date = date;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("date")
  public Date getDate() {
    return date;
  }
  public void setDate(Date date) {
    this.date = date;
  }

  /**
   **/
  public BaseCommit message(String message) {
    this.message = message;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("message")
  public String getMessage() {
    return message;
  }
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   **/
  public BaseCommit summary(Object summary) {
    this.summary = summary;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("summary")
  public Object getSummary() {
    return summary;
  }
  public void setSummary(Object summary) {
    this.summary = summary;
  }

  /**
   **/
  public BaseCommit author(Author author) {
    this.author = author;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("author")
  public Author getAuthor() {
    return author;
  }
  public void setAuthor(Author author) {
    this.author = author;
  }

  /**
   **/
  public BaseCommit hash(String hash) {
    this.hash = hash;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("hash")
 @Pattern(regexp="[0-9a-f]{7,}?")  public String getHash() {
    return hash;
  }
  public void setHash(String hash) {
    this.hash = hash;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseCommit baseCommit = (BaseCommit) o;
    return Objects.equals(parents, baseCommit.parents) &&
        Objects.equals(date, baseCommit.date) &&
        Objects.equals(message, baseCommit.message) &&
        Objects.equals(summary, baseCommit.summary) &&
        Objects.equals(author, baseCommit.author) &&
        Objects.equals(hash, baseCommit.hash);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parents, date, message, summary, author, hash);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseCommit {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    parents: ").append(toIndentedString(parents)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    hash: ").append(toIndentedString(hash)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

