package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class BranchingModelSettings extends Object  {
  
  private @Valid Object development = null;
  private @Valid Object links = null;
  private @Valid Object production = null;
  private @Valid List<Object> branchTypes = new ArrayList<Object>();

  /**
   **/
  public BranchingModelSettings development(Object development) {
    this.development = development;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("development")
  public Object getDevelopment() {
    return development;
  }
  public void setDevelopment(Object development) {
    this.development = development;
  }

  /**
   **/
  public BranchingModelSettings links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   **/
  public BranchingModelSettings production(Object production) {
    this.production = production;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("production")
  public Object getProduction() {
    return production;
  }
  public void setProduction(Object production) {
    this.production = production;
  }

  /**
   **/
  public BranchingModelSettings branchTypes(List<Object> branchTypes) {
    this.branchTypes = branchTypes;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("branch_types")
 @Size(min=0,max=4)  public List<Object> getBranchTypes() {
    return branchTypes;
  }
  public void setBranchTypes(List<Object> branchTypes) {
    this.branchTypes = branchTypes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BranchingModelSettings branchingModelSettings = (BranchingModelSettings) o;
    return Objects.equals(development, branchingModelSettings.development) &&
        Objects.equals(links, branchingModelSettings.links) &&
        Objects.equals(production, branchingModelSettings.production) &&
        Objects.equals(branchTypes, branchingModelSettings.branchTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(development, links, production, branchTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BranchingModelSettings {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    development: ").append(toIndentedString(development)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    production: ").append(toIndentedString(production)).append("\n");
    sb.append("    branchTypes: ").append(toIndentedString(branchTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

