package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.Group;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Branchrestriction extends Object  {
  
  private @Valid String pattern;

public enum KindEnum {

    REQUIRE_TASKS_TO_BE_COMPLETED(String.valueOf("require_tasks_to_be_completed")), REQUIRE_PASSING_BUILDS_TO_MERGE(String.valueOf("require_passing_builds_to_merge")), FORCE(String.valueOf("force")), REQUIRE_ALL_DEPENDENCIES_MERGED(String.valueOf("require_all_dependencies_merged")), PUSH(String.valueOf("push")), REQUIRE_APPROVALS_TO_MERGE(String.valueOf("require_approvals_to_merge")), ENFORCE_MERGE_CHECKS(String.valueOf("enforce_merge_checks")), RESTRICT_MERGES(String.valueOf("restrict_merges")), RESET_PULLREQUEST_APPROVALS_ON_CHANGE(String.valueOf("reset_pullrequest_approvals_on_change")), DELETE(String.valueOf("delete"));


    private String value;

    KindEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static KindEnum fromValue(String v) {
        for (KindEnum b : KindEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid KindEnum kind;

public enum BranchMatchKindEnum {

    BRANCHING_MODEL(String.valueOf("branching_model")), GLOB(String.valueOf("glob"));


    private String value;

    BranchMatchKindEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static BranchMatchKindEnum fromValue(String v) {
        for (BranchMatchKindEnum b : BranchMatchKindEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid BranchMatchKindEnum branchMatchKind;
  private @Valid Object links = null;

public enum BranchTypeEnum {

    FEATURE(String.valueOf("feature")), BUGFIX(String.valueOf("bugfix")), RELEASE(String.valueOf("release")), HOTFIX(String.valueOf("hotfix")), DEVELOPMENT(String.valueOf("development")), PRODUCTION(String.valueOf("production"));


    private String value;

    BranchTypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static BranchTypeEnum fromValue(String v) {
        for (BranchTypeEnum b : BranchTypeEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid BranchTypeEnum branchType;
  private @Valid List<Account> users = new ArrayList<Account>();
  private @Valid Integer id;
  private @Valid List<Group> groups = new ArrayList<Group>();
  private @Valid Integer value;

  /**
   * Apply the restriction to branches that match this pattern. Active when &#x60;branch_match_kind&#x60; is &#x60;glob&#x60;. Will be empty when &#x60;branch_match_kind&#x60; is &#x60;branching_model&#x60;.
   **/
  public Branchrestriction pattern(String pattern) {
    this.pattern = pattern;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Apply the restriction to branches that match this pattern. Active when `branch_match_kind` is `glob`. Will be empty when `branch_match_kind` is `branching_model`.")
  @JsonProperty("pattern")
  @NotNull
  public String getPattern() {
    return pattern;
  }
  public void setPattern(String pattern) {
    this.pattern = pattern;
  }

  /**
   * The type of restriction that is being applied.
   **/
  public Branchrestriction kind(KindEnum kind) {
    this.kind = kind;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "The type of restriction that is being applied.")
  @JsonProperty("kind")
  @NotNull
  public KindEnum getKind() {
    return kind;
  }
  public void setKind(KindEnum kind) {
    this.kind = kind;
  }

  /**
   * Indicates how the restriction is matched against a branch. The default is &#x60;glob&#x60;.
   **/
  public Branchrestriction branchMatchKind(BranchMatchKindEnum branchMatchKind) {
    this.branchMatchKind = branchMatchKind;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Indicates how the restriction is matched against a branch. The default is `glob`.")
  @JsonProperty("branch_match_kind")
  @NotNull
  public BranchMatchKindEnum getBranchMatchKind() {
    return branchMatchKind;
  }
  public void setBranchMatchKind(BranchMatchKindEnum branchMatchKind) {
    this.branchMatchKind = branchMatchKind;
  }

  /**
   **/
  public Branchrestriction links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * Apply the restriction to branches of this type. Active when &#x60;branch_match_kind&#x60; is &#x60;branching_model&#x60;. The branch type will be calculated using the branching model configured for the repository.
   **/
  public Branchrestriction branchType(BranchTypeEnum branchType) {
    this.branchType = branchType;
    return this;
  }

  
  @ApiModelProperty(value = "Apply the restriction to branches of this type. Active when `branch_match_kind` is `branching_model`. The branch type will be calculated using the branching model configured for the repository.")
  @JsonProperty("branch_type")
  public BranchTypeEnum getBranchType() {
    return branchType;
  }
  public void setBranchType(BranchTypeEnum branchType) {
    this.branchType = branchType;
  }

  /**
   **/
  public Branchrestriction users(List<Account> users) {
    this.users = users;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("users")
 @Size(min=0)  public List<Account> getUsers() {
    return users;
  }
  public void setUsers(List<Account> users) {
    this.users = users;
  }

  /**
   * The branch restriction status&#39; id.
   **/
  public Branchrestriction id(Integer id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "The branch restriction status' id.")
  @JsonProperty("id")
  public Integer getId() {
    return id;
  }
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   **/
  public Branchrestriction groups(List<Group> groups) {
    this.groups = groups;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("groups")
 @Size(min=0)  public List<Group> getGroups() {
    return groups;
  }
  public void setGroups(List<Group> groups) {
    this.groups = groups;
  }

  /**
   * Value with kind-specific semantics: \&quot;require_approvals_to_merge\&quot; uses it to require a minimum number of approvals on a PR; \&quot;require_passing_builds_to_merge\&quot; uses it to require a minimum number of passing builds.
   **/
  public Branchrestriction value(Integer value) {
    this.value = value;
    return this;
  }

  
  @ApiModelProperty(value = "Value with kind-specific semantics: \"require_approvals_to_merge\" uses it to require a minimum number of approvals on a PR; \"require_passing_builds_to_merge\" uses it to require a minimum number of passing builds.")
  @JsonProperty("value")
  public Integer getValue() {
    return value;
  }
  public void setValue(Integer value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Branchrestriction branchrestriction = (Branchrestriction) o;
    return Objects.equals(pattern, branchrestriction.pattern) &&
        Objects.equals(kind, branchrestriction.kind) &&
        Objects.equals(branchMatchKind, branchrestriction.branchMatchKind) &&
        Objects.equals(links, branchrestriction.links) &&
        Objects.equals(branchType, branchrestriction.branchType) &&
        Objects.equals(users, branchrestriction.users) &&
        Objects.equals(id, branchrestriction.id) &&
        Objects.equals(groups, branchrestriction.groups) &&
        Objects.equals(value, branchrestriction.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pattern, kind, branchMatchKind, links, branchType, users, id, groups, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Branchrestriction {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    pattern: ").append(toIndentedString(pattern)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    branchMatchKind: ").append(toIndentedString(branchMatchKind)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    branchType: ").append(toIndentedString(branchType)).append("\n");
    sb.append("    users: ").append(toIndentedString(users)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

