package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Comment;
import se.bjurr.bitbucketcloud.gen.model.CommentContent;
import se.bjurr.bitbucketcloud.gen.model.CommentInline;
import se.bjurr.bitbucketcloud.gen.model.User;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Comment extends Object  {
  
  private @Valid Object links = null;
  private @Valid CommentInline inline = null;
  private @Valid Comment parent = null;
  private @Valid User user = null;
  private @Valid CommentContent content = null;
  private @Valid Boolean deleted;
  private @Valid Integer id;
  private @Valid Date createdOn;
  private @Valid Date updatedOn;

  /**
   **/
  public Comment links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   **/
  public Comment inline(CommentInline inline) {
    this.inline = inline;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("inline")
  public CommentInline getInline() {
    return inline;
  }
  public void setInline(CommentInline inline) {
    this.inline = inline;
  }

  /**
   **/
  public Comment parent(Comment parent) {
    this.parent = parent;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("parent")
  public Comment getParent() {
    return parent;
  }
  public void setParent(Comment parent) {
    this.parent = parent;
  }

  /**
   **/
  public Comment user(User user) {
    this.user = user;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("user")
  public User getUser() {
    return user;
  }
  public void setUser(User user) {
    this.user = user;
  }

  /**
   **/
  public Comment content(CommentContent content) {
    this.content = content;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("content")
  public CommentContent getContent() {
    return content;
  }
  public void setContent(CommentContent content) {
    this.content = content;
  }

  /**
   **/
  public Comment deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("deleted")
  public Boolean getDeleted() {
    return deleted;
  }
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   **/
  public Comment id(Integer id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("id")
  public Integer getId() {
    return id;
  }
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   **/
  public Comment createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public Comment updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Comment comment = (Comment) o;
    return Objects.equals(links, comment.links) &&
        Objects.equals(inline, comment.inline) &&
        Objects.equals(parent, comment.parent) &&
        Objects.equals(user, comment.user) &&
        Objects.equals(content, comment.content) &&
        Objects.equals(deleted, comment.deleted) &&
        Objects.equals(id, comment.id) &&
        Objects.equals(createdOn, comment.createdOn) &&
        Objects.equals(updatedOn, comment.updatedOn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, inline, parent, user, content, deleted, id, createdOn, updatedOn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Comment {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    inline: ").append(toIndentedString(inline)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

