package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A file object, representing a file at a commit in a repository
 **/
@ApiModel(description = "A file object, representing a file at a commit in a repository")
public class CommitFile   {
  

public enum AttributesEnum {

    LINK(String.valueOf("link")), EXECUTABLE(String.valueOf("executable")), SUBREPOSITORY(String.valueOf("subrepository")), BINARY(String.valueOf("binary")), LFS(String.valueOf("lfs"));


    private String value;

    AttributesEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static AttributesEnum fromValue(String v) {
        for (AttributesEnum b : AttributesEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid AttributesEnum attributes;
  private @Valid String type;
  private @Valid Commit commit = null;
  private @Valid String path;

  /**
   **/
  public CommitFile attributes(AttributesEnum attributes) {
    this.attributes = attributes;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("attributes")
  public AttributesEnum getAttributes() {
    return attributes;
  }
  public void setAttributes(AttributesEnum attributes) {
    this.attributes = attributes;
  }

  /**
   **/
  public CommitFile type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public CommitFile commit(Commit commit) {
    this.commit = commit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("commit")
  public Commit getCommit() {
    return commit;
  }
  public void setCommit(Commit commit) {
    this.commit = commit;
  }

  /**
   * The path in the repository
   **/
  public CommitFile path(String path) {
    this.path = path;
    return this;
  }

  
  @ApiModelProperty(value = "The path in the repository")
  @JsonProperty("path")
  public String getPath() {
    return path;
  }
  public void setPath(String path) {
    this.path = path;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommitFile commitFile = (CommitFile) o;
    return Objects.equals(attributes, commitFile.attributes) &&
        Objects.equals(type, commitFile.type) &&
        Objects.equals(commit, commitFile.commit) &&
        Objects.equals(path, commitFile.path);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributes, type, commit, path);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommitFile {\n");
    
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    commit: ").append(toIndentedString(commit)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

