package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Commitstatus extends Object  {
  
  private @Valid String description;
  private @Valid Date updatedOn;
  private @Valid String refname;
  private @Valid String key;
  private @Valid Date createdOn;
  private @Valid String url;
  private @Valid String name;
  private @Valid Object links = null;
  private @Valid String uuid;

public enum StateEnum {

    SUCCESSFUL(String.valueOf("SUCCESSFUL")), FAILED(String.valueOf("FAILED")), INPROGRESS(String.valueOf("INPROGRESS")), STOPPED(String.valueOf("STOPPED"));


    private String value;

    StateEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String v) {
        for (StateEnum b : StateEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid StateEnum state;

  /**
   * A description of the build (e.g. \&quot;Unit tests in Bamboo\&quot;)
   **/
  public Commitstatus description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "A description of the build (e.g. \"Unit tests in Bamboo\")")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public Commitstatus updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   *  The name of the ref that pointed to this commit at the time the status object was created. Note that this the ref may since have moved off of the commit. This optional field can be useful for build systems whose build triggers and configuration are branch-dependent (e.g. a Pipeline build). It is legitimate for this field to not be set, or even apply (e.g. a static linting job).
   **/
  public Commitstatus refname(String refname) {
    this.refname = refname;
    return this;
  }

  
  @ApiModelProperty(value = " The name of the ref that pointed to this commit at the time the status object was created. Note that this the ref may since have moved off of the commit. This optional field can be useful for build systems whose build triggers and configuration are branch-dependent (e.g. a Pipeline build). It is legitimate for this field to not be set, or even apply (e.g. a static linting job).")
  @JsonProperty("refname")
  public String getRefname() {
    return refname;
  }
  public void setRefname(String refname) {
    this.refname = refname;
  }

  /**
   * An identifier for the status that&#39;s unique to         its type (current \&quot;build\&quot; is the only supported type) and the vendor,         e.g. BB-DEPLOY
   **/
  public Commitstatus key(String key) {
    this.key = key;
    return this;
  }

  
  @ApiModelProperty(value = "An identifier for the status that's unique to         its type (current \"build\" is the only supported type) and the vendor,         e.g. BB-DEPLOY")
  @JsonProperty("key")
  public String getKey() {
    return key;
  }
  public void setKey(String key) {
    this.key = key;
  }

  /**
   **/
  public Commitstatus createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   * A URL linking back to the vendor or build system, for providing more information about whatever process produced this status. Accepts context variables &#x60;repository&#x60; and &#x60;commit&#x60; that Bitbucket will evaluate at runtime whenever at runtime. For example, one could use https://foo.com/builds/{repository.full_name} which Bitbucket will turn into https://foo.com/builds/foo/bar at render time.
   **/
  public Commitstatus url(String url) {
    this.url = url;
    return this;
  }

  
  @ApiModelProperty(value = "A URL linking back to the vendor or build system, for providing more information about whatever process produced this status. Accepts context variables `repository` and `commit` that Bitbucket will evaluate at runtime whenever at runtime. For example, one could use https://foo.com/builds/{repository.full_name} which Bitbucket will turn into https://foo.com/builds/foo/bar at render time.")
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * An identifier for the build itself, e.g. BB-DEPLOY-1
   **/
  public Commitstatus name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "An identifier for the build itself, e.g. BB-DEPLOY-1")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   **/
  public Commitstatus links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * The commit status&#39; id.
   **/
  public Commitstatus uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The commit status' id.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   * Provides some indication of the status of this commit
   **/
  public Commitstatus state(StateEnum state) {
    this.state = state;
    return this;
  }

  
  @ApiModelProperty(value = "Provides some indication of the status of this commit")
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }
  public void setState(StateEnum state) {
    this.state = state;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Commitstatus commitstatus = (Commitstatus) o;
    return Objects.equals(description, commitstatus.description) &&
        Objects.equals(updatedOn, commitstatus.updatedOn) &&
        Objects.equals(refname, commitstatus.refname) &&
        Objects.equals(key, commitstatus.key) &&
        Objects.equals(createdOn, commitstatus.createdOn) &&
        Objects.equals(url, commitstatus.url) &&
        Objects.equals(name, commitstatus.name) &&
        Objects.equals(links, commitstatus.links) &&
        Objects.equals(uuid, commitstatus.uuid) &&
        Objects.equals(state, commitstatus.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, updatedOn, refname, key, createdOn, url, name, links, uuid, state);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Commitstatus {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    refname: ").append(toIndentedString(refname)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

