package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.DeploymentEnvironment;
import se.bjurr.bitbucketcloud.gen.model.DeploymentRelease;
import se.bjurr.bitbucketcloud.gen.model.DeploymentState;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Deployment extends Object  {
  
  private @Valid DeploymentEnvironment environment = null;
  private @Valid DeploymentState state = null;
  private @Valid DeploymentRelease release = null;
  private @Valid String uuid;

  /**
   **/
  public Deployment environment(DeploymentEnvironment environment) {
    this.environment = environment;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("environment")
  public DeploymentEnvironment getEnvironment() {
    return environment;
  }
  public void setEnvironment(DeploymentEnvironment environment) {
    this.environment = environment;
  }

  /**
   **/
  public Deployment state(DeploymentState state) {
    this.state = state;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("state")
  public DeploymentState getState() {
    return state;
  }
  public void setState(DeploymentState state) {
    this.state = state;
  }

  /**
   **/
  public Deployment release(DeploymentRelease release) {
    this.release = release;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("release")
  public DeploymentRelease getRelease() {
    return release;
  }
  public void setRelease(DeploymentRelease release) {
    this.release = release;
  }

  /**
   * The UUID identifying the deployment.
   **/
  public Deployment uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the deployment.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Deployment deployment = (Deployment) o;
    return Objects.equals(environment, deployment.environment) &&
        Objects.equals(state, deployment.state) &&
        Objects.equals(release, deployment.release) &&
        Objects.equals(uuid, deployment.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(environment, state, release, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Deployment {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    release: ").append(toIndentedString(release)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

