package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.DeploymentState;
import se.bjurr.bitbucketcloud.gen.model.DeploymentStateCompletedStatus;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class DeploymentStateCompleted extends DeploymentState  {
  
  private @Valid Account deployer = null;
  private @Valid String url;

public enum NameEnum {

    COMPLETED(String.valueOf("COMPLETED"));


    private String value;

    NameEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static NameEnum fromValue(String v) {
        for (NameEnum b : NameEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid NameEnum name;
  private @Valid Date completionDate;
  private @Valid DeploymentStateCompletedStatus status = null;
  private @Valid Date startDate;

  /**
   **/
  public DeploymentStateCompleted deployer(Account deployer) {
    this.deployer = deployer;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("deployer")
  public Account getDeployer() {
    return deployer;
  }
  public void setDeployer(Account deployer) {
    this.deployer = deployer;
  }

  /**
   * Link to the deployment result.
   **/
  public DeploymentStateCompleted url(String url) {
    this.url = url;
    return this;
  }

  
  @ApiModelProperty(value = "Link to the deployment result.")
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * The name of deployment state (COMPLETED).
   **/
  public DeploymentStateCompleted name(NameEnum name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of deployment state (COMPLETED).")
  @JsonProperty("name")
  public NameEnum getName() {
    return name;
  }
  public void setName(NameEnum name) {
    this.name = name;
  }

  /**
   * The timestamp when the deployment completed.
   **/
  public DeploymentStateCompleted completionDate(Date completionDate) {
    this.completionDate = completionDate;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the deployment completed.")
  @JsonProperty("completion_date")
  public Date getCompletionDate() {
    return completionDate;
  }
  public void setCompletionDate(Date completionDate) {
    this.completionDate = completionDate;
  }

  /**
   **/
  public DeploymentStateCompleted status(DeploymentStateCompletedStatus status) {
    this.status = status;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("status")
  public DeploymentStateCompletedStatus getStatus() {
    return status;
  }
  public void setStatus(DeploymentStateCompletedStatus status) {
    this.status = status;
  }

  /**
   * The timestamp when the deployment was started.
   **/
  public DeploymentStateCompleted startDate(Date startDate) {
    this.startDate = startDate;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the deployment was started.")
  @JsonProperty("start_date")
  public Date getStartDate() {
    return startDate;
  }
  public void setStartDate(Date startDate) {
    this.startDate = startDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentStateCompleted deploymentStateCompleted = (DeploymentStateCompleted) o;
    return Objects.equals(deployer, deploymentStateCompleted.deployer) &&
        Objects.equals(url, deploymentStateCompleted.url) &&
        Objects.equals(name, deploymentStateCompleted.name) &&
        Objects.equals(completionDate, deploymentStateCompleted.completionDate) &&
        Objects.equals(status, deploymentStateCompleted.status) &&
        Objects.equals(startDate, deploymentStateCompleted.startDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deployer, url, name, completionDate, status, startDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentStateCompleted {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    deployer: ").append(toIndentedString(deployer)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    completionDate: ").append(toIndentedString(completionDate)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

