package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.DeploymentState;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class DeploymentStateInProgress extends DeploymentState  {
  

public enum NameEnum {

    IN_PROGRESS(String.valueOf("IN_PROGRESS"));


    private String value;

    NameEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static NameEnum fromValue(String v) {
        for (NameEnum b : NameEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid NameEnum name;
  private @Valid String url;
  private @Valid Date startDate;
  private @Valid Account deployer = null;

  /**
   * The name of deployment state (IN_PROGRESS).
   **/
  public DeploymentStateInProgress name(NameEnum name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of deployment state (IN_PROGRESS).")
  @JsonProperty("name")
  public NameEnum getName() {
    return name;
  }
  public void setName(NameEnum name) {
    this.name = name;
  }

  /**
   * Link to the deployment result.
   **/
  public DeploymentStateInProgress url(String url) {
    this.url = url;
    return this;
  }

  
  @ApiModelProperty(value = "Link to the deployment result.")
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * The timestamp when the deployment was started.
   **/
  public DeploymentStateInProgress startDate(Date startDate) {
    this.startDate = startDate;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the deployment was started.")
  @JsonProperty("start_date")
  public Date getStartDate() {
    return startDate;
  }
  public void setStartDate(Date startDate) {
    this.startDate = startDate;
  }

  /**
   **/
  public DeploymentStateInProgress deployer(Account deployer) {
    this.deployer = deployer;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("deployer")
  public Account getDeployer() {
    return deployer;
  }
  public void setDeployer(Account deployer) {
    this.deployer = deployer;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentStateInProgress deploymentStateInProgress = (DeploymentStateInProgress) o;
    return Objects.equals(name, deploymentStateInProgress.name) &&
        Objects.equals(url, deploymentStateInProgress.url) &&
        Objects.equals(startDate, deploymentStateInProgress.startDate) &&
        Objects.equals(deployer, deploymentStateInProgress.deployer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, url, startDate, deployer);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentStateInProgress {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    deployer: ").append(toIndentedString(deployer)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

