package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.DeploymentState;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class DeploymentStateUndeployed extends DeploymentState  {
  

public enum NameEnum {

    UNDEPLOYED(String.valueOf("UNDEPLOYED"));


    private String value;

    NameEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static NameEnum fromValue(String v) {
        for (NameEnum b : NameEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid NameEnum name;
  private @Valid String triggerUrl;

  /**
   * The name of deployment state (UNDEPLOYED).
   **/
  public DeploymentStateUndeployed name(NameEnum name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of deployment state (UNDEPLOYED).")
  @JsonProperty("name")
  public NameEnum getName() {
    return name;
  }
  public void setName(NameEnum name) {
    this.name = name;
  }

  /**
   * Link to trigger the deployment.
   **/
  public DeploymentStateUndeployed triggerUrl(String triggerUrl) {
    this.triggerUrl = triggerUrl;
    return this;
  }

  
  @ApiModelProperty(value = "Link to trigger the deployment.")
  @JsonProperty("trigger_url")
  public String getTriggerUrl() {
    return triggerUrl;
  }
  public void setTriggerUrl(String triggerUrl) {
    this.triggerUrl = triggerUrl;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentStateUndeployed deploymentStateUndeployed = (DeploymentStateUndeployed) o;
    return Objects.equals(name, deploymentStateUndeployed.name) &&
        Objects.equals(triggerUrl, deploymentStateUndeployed.triggerUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, triggerUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentStateUndeployed {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    triggerUrl: ").append(toIndentedString(triggerUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

