package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.CommitFile;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A diffstat object that includes a summary of changes made to a file between two commits.
 **/
@ApiModel(description = "A diffstat object that includes a summary of changes made to a file between two commits.")
public class Diffstat   {
  
  private @Valid Integer linesAdded;
  private @Valid CommitFile old = null;
  private @Valid String type;

public enum StatusEnum {

    ADDED(String.valueOf("added")), REMOVED(String.valueOf("removed")), MODIFIED(String.valueOf("modified")), RENAMED(String.valueOf("renamed"));


    private String value;

    StatusEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String v) {
        for (StatusEnum b : StatusEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid StatusEnum status;
  private @Valid Integer linesRemoved;
  private @Valid CommitFile _new = null;

  /**
   **/
  public Diffstat linesAdded(Integer linesAdded) {
    this.linesAdded = linesAdded;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("lines_added")
  public Integer getLinesAdded() {
    return linesAdded;
  }
  public void setLinesAdded(Integer linesAdded) {
    this.linesAdded = linesAdded;
  }

  /**
   **/
  public Diffstat old(CommitFile old) {
    this.old = old;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("old")
  public CommitFile getOld() {
    return old;
  }
  public void setOld(CommitFile old) {
    this.old = old;
  }

  /**
   **/
  public Diffstat type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public Diffstat status(StatusEnum status) {
    this.status = status;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("status")
  public StatusEnum getStatus() {
    return status;
  }
  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  /**
   **/
  public Diffstat linesRemoved(Integer linesRemoved) {
    this.linesRemoved = linesRemoved;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("lines_removed")
  public Integer getLinesRemoved() {
    return linesRemoved;
  }
  public void setLinesRemoved(Integer linesRemoved) {
    this.linesRemoved = linesRemoved;
  }

  /**
   **/
  public Diffstat _new(CommitFile _new) {
    this._new = _new;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("new")
  public CommitFile getNew() {
    return _new;
  }
  public void setNew(CommitFile _new) {
    this._new = _new;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Diffstat diffstat = (Diffstat) o;
    return Objects.equals(linesAdded, diffstat.linesAdded) &&
        Objects.equals(old, diffstat.old) &&
        Objects.equals(type, diffstat.type) &&
        Objects.equals(status, diffstat.status) &&
        Objects.equals(linesRemoved, diffstat.linesRemoved) &&
        Objects.equals(_new, diffstat._new);
  }

  @Override
  public int hashCode() {
    return Objects.hash(linesAdded, old, type, status, linesRemoved, _new);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Diffstat {\n");
    
    sb.append("    linesAdded: ").append(toIndentedString(linesAdded)).append("\n");
    sb.append("    old: ").append(toIndentedString(old)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    linesRemoved: ").append(toIndentedString(linesRemoved)).append("\n");
    sb.append("    _new: ").append(toIndentedString(_new)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

