package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Component;
import se.bjurr.bitbucketcloud.gen.model.Milestone;
import se.bjurr.bitbucketcloud.gen.model.Repository;
import se.bjurr.bitbucketcloud.gen.model.User;
import se.bjurr.bitbucketcloud.gen.model.Version;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Issue extends Object  {
  
  private @Valid String title;
  private @Valid Integer id;
  private @Valid User assignee = null;
  private @Valid Component component = null;
  private @Valid Integer votes;
  private @Valid Repository repository = null;
  private @Valid Milestone milestone = null;
  private @Valid User reporter = null;
  private @Valid Date updatedOn;
  private @Valid Date createdOn;

public enum PriorityEnum {

    TRIVIAL(String.valueOf("trivial")), MINOR(String.valueOf("minor")), MAJOR(String.valueOf("major")), CRITICAL(String.valueOf("critical")), BLOCKER(String.valueOf("blocker"));


    private String value;

    PriorityEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String v) {
        for (PriorityEnum b : PriorityEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid PriorityEnum priority;
  private @Valid Version version = null;
  private @Valid Object content = null;

public enum StateEnum {

    NEW(String.valueOf("new")), OPEN(String.valueOf("open")), RESOLVED(String.valueOf("resolved")), ON_HOLD(String.valueOf("on hold")), INVALID(String.valueOf("invalid")), DUPLICATE(String.valueOf("duplicate")), WONTFIX(String.valueOf("wontfix")), CLOSED(String.valueOf("closed"));


    private String value;

    StateEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String v) {
        for (StateEnum b : StateEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid StateEnum state;
  private @Valid Object links = null;

public enum KindEnum {

    BUG(String.valueOf("bug")), ENHANCEMENT(String.valueOf("enhancement")), PROPOSAL(String.valueOf("proposal")), TASK(String.valueOf("task"));


    private String value;

    KindEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static KindEnum fromValue(String v) {
        for (KindEnum b : KindEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid KindEnum kind;
  private @Valid Date editedOn;

  /**
   **/
  public Issue title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public Issue id(Integer id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("id")
  public Integer getId() {
    return id;
  }
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   **/
  public Issue assignee(User assignee) {
    this.assignee = assignee;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("assignee")
  public User getAssignee() {
    return assignee;
  }
  public void setAssignee(User assignee) {
    this.assignee = assignee;
  }

  /**
   **/
  public Issue component(Component component) {
    this.component = component;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("component")
  public Component getComponent() {
    return component;
  }
  public void setComponent(Component component) {
    this.component = component;
  }

  /**
   **/
  public Issue votes(Integer votes) {
    this.votes = votes;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("votes")
  public Integer getVotes() {
    return votes;
  }
  public void setVotes(Integer votes) {
    this.votes = votes;
  }

  /**
   **/
  public Issue repository(Repository repository) {
    this.repository = repository;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("repository")
  public Repository getRepository() {
    return repository;
  }
  public void setRepository(Repository repository) {
    this.repository = repository;
  }

  /**
   **/
  public Issue milestone(Milestone milestone) {
    this.milestone = milestone;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("milestone")
  public Milestone getMilestone() {
    return milestone;
  }
  public void setMilestone(Milestone milestone) {
    this.milestone = milestone;
  }

  /**
   **/
  public Issue reporter(User reporter) {
    this.reporter = reporter;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("reporter")
  public User getReporter() {
    return reporter;
  }
  public void setReporter(User reporter) {
    this.reporter = reporter;
  }

  /**
   **/
  public Issue updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   **/
  public Issue createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   **/
  public Issue priority(PriorityEnum priority) {
    this.priority = priority;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("priority")
  public PriorityEnum getPriority() {
    return priority;
  }
  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }

  /**
   **/
  public Issue version(Version version) {
    this.version = version;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("version")
  public Version getVersion() {
    return version;
  }
  public void setVersion(Version version) {
    this.version = version;
  }

  /**
   **/
  public Issue content(Object content) {
    this.content = content;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("content")
  public Object getContent() {
    return content;
  }
  public void setContent(Object content) {
    this.content = content;
  }

  /**
   **/
  public Issue state(StateEnum state) {
    this.state = state;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }
  public void setState(StateEnum state) {
    this.state = state;
  }

  /**
   **/
  public Issue links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   **/
  public Issue kind(KindEnum kind) {
    this.kind = kind;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("kind")
  public KindEnum getKind() {
    return kind;
  }
  public void setKind(KindEnum kind) {
    this.kind = kind;
  }

  /**
   **/
  public Issue editedOn(Date editedOn) {
    this.editedOn = editedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("edited_on")
  public Date getEditedOn() {
    return editedOn;
  }
  public void setEditedOn(Date editedOn) {
    this.editedOn = editedOn;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Issue issue = (Issue) o;
    return Objects.equals(title, issue.title) &&
        Objects.equals(id, issue.id) &&
        Objects.equals(assignee, issue.assignee) &&
        Objects.equals(component, issue.component) &&
        Objects.equals(votes, issue.votes) &&
        Objects.equals(repository, issue.repository) &&
        Objects.equals(milestone, issue.milestone) &&
        Objects.equals(reporter, issue.reporter) &&
        Objects.equals(updatedOn, issue.updatedOn) &&
        Objects.equals(createdOn, issue.createdOn) &&
        Objects.equals(priority, issue.priority) &&
        Objects.equals(version, issue.version) &&
        Objects.equals(content, issue.content) &&
        Objects.equals(state, issue.state) &&
        Objects.equals(links, issue.links) &&
        Objects.equals(kind, issue.kind) &&
        Objects.equals(editedOn, issue.editedOn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, id, assignee, component, votes, repository, milestone, reporter, updatedOn, createdOn, priority, version, content, state, links, kind, editedOn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Issue {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    component: ").append(toIndentedString(component)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("    milestone: ").append(toIndentedString(milestone)).append("\n");
    sb.append("    reporter: ").append(toIndentedString(reporter)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    editedOn: ").append(toIndentedString(editedOn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

