package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Comment;
import se.bjurr.bitbucketcloud.gen.model.CommentContent;
import se.bjurr.bitbucketcloud.gen.model.CommentInline;
import se.bjurr.bitbucketcloud.gen.model.Issue;
import se.bjurr.bitbucketcloud.gen.model.User;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class IssueComment extends Comment  {
  
  private @Valid Issue issue = null;

  /**
   **/
  public IssueComment issue(Issue issue) {
    this.issue = issue;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("issue")
  public Issue getIssue() {
    return issue;
  }
  public void setIssue(Issue issue) {
    this.issue = issue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IssueComment issueComment = (IssueComment) o;
    return Objects.equals(issue, issueComment.issue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(issue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IssueComment {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    issue: ").append(toIndentedString(issue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

