package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.PipelineStep;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A paged list of pipeline steps.
 **/
@ApiModel(description = "A paged list of pipeline steps.")
public class PaginatedPipelineSteps   {
  
  private @Valid String previous;
  private @Valid Integer page;
  private @Valid List<PipelineStep> values = new ArrayList<PipelineStep>();
  private @Valid String next;
  private @Valid Integer size;
  private @Valid Integer pagelen;

  /**
   * Link to previous page if it exists. A collections first page does not have this value. This is an optional element that is not provided in all responses. Some result sets strictly support forward navigation and never provide previous links. Clients must anticipate that backwards navigation is not always available. Use this link to navigate the result set and refrain from constructing your own URLs.
   **/
  public PaginatedPipelineSteps previous(String previous) {
    this.previous = previous;
    return this;
  }

  
  @ApiModelProperty(value = "Link to previous page if it exists. A collections first page does not have this value. This is an optional element that is not provided in all responses. Some result sets strictly support forward navigation and never provide previous links. Clients must anticipate that backwards navigation is not always available. Use this link to navigate the result set and refrain from constructing your own URLs.")
  @JsonProperty("previous")
  public String getPrevious() {
    return previous;
  }
  public void setPrevious(String previous) {
    this.previous = previous;
  }

  /**
   * Page number of the current results. This is an optional element that is not provided in all responses.
   **/
  public PaginatedPipelineSteps page(Integer page) {
    this.page = page;
    return this;
  }

  
  @ApiModelProperty(value = "Page number of the current results. This is an optional element that is not provided in all responses.")
  @JsonProperty("page")
  public Integer getPage() {
    return page;
  }
  public void setPage(Integer page) {
    this.page = page;
  }

  /**
   * The values of the current page.
   **/
  public PaginatedPipelineSteps values(List<PipelineStep> values) {
    this.values = values;
    return this;
  }

  
  @ApiModelProperty(value = "The values of the current page.")
  @JsonProperty("values")
 @Size(min=0)  public List<PipelineStep> getValues() {
    return values;
  }
  public void setValues(List<PipelineStep> values) {
    this.values = values;
  }

  /**
   * Link to the next page if it exists. The last page of a collection does not have this value. Use this link to navigate the result set and refrain from constructing your own URLs.
   **/
  public PaginatedPipelineSteps next(String next) {
    this.next = next;
    return this;
  }

  
  @ApiModelProperty(value = "Link to the next page if it exists. The last page of a collection does not have this value. Use this link to navigate the result set and refrain from constructing your own URLs.")
  @JsonProperty("next")
  public String getNext() {
    return next;
  }
  public void setNext(String next) {
    this.next = next;
  }

  /**
   * Total number of objects in the response. This is an optional element that is not provided in all responses, as it can be expensive to compute.
   **/
  public PaginatedPipelineSteps size(Integer size) {
    this.size = size;
    return this;
  }

  
  @ApiModelProperty(value = "Total number of objects in the response. This is an optional element that is not provided in all responses, as it can be expensive to compute.")
  @JsonProperty("size")
  public Integer getSize() {
    return size;
  }
  public void setSize(Integer size) {
    this.size = size;
  }

  /**
   * Current number of objects on the existing page. The default value is 10 with 100 being the maximum allowed value. Individual APIs may enforce different values.
   **/
  public PaginatedPipelineSteps pagelen(Integer pagelen) {
    this.pagelen = pagelen;
    return this;
  }

  
  @ApiModelProperty(value = "Current number of objects on the existing page. The default value is 10 with 100 being the maximum allowed value. Individual APIs may enforce different values.")
  @JsonProperty("pagelen")
  public Integer getPagelen() {
    return pagelen;
  }
  public void setPagelen(Integer pagelen) {
    this.pagelen = pagelen;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedPipelineSteps paginatedPipelineSteps = (PaginatedPipelineSteps) o;
    return Objects.equals(previous, paginatedPipelineSteps.previous) &&
        Objects.equals(page, paginatedPipelineSteps.page) &&
        Objects.equals(values, paginatedPipelineSteps.values) &&
        Objects.equals(next, paginatedPipelineSteps.next) &&
        Objects.equals(size, paginatedPipelineSteps.size) &&
        Objects.equals(pagelen, paginatedPipelineSteps.pagelen);
  }

  @Override
  public int hashCode() {
    return Objects.hash(previous, page, values, next, size, pagelen);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedPipelineSteps {\n");
    
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    pagelen: ").append(toIndentedString(pagelen)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

