package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PaginatedPullrequestsCommits   {
  
  private @Valid String next;
  private @Valid Integer pagelen;
  private @Valid Integer page;
  private @Valid String previous;
  private @Valid List<Commit> values = new ArrayList<Commit>();
  private @Valid Integer size;

  /**
   **/
  public PaginatedPullrequestsCommits next(String next) {
    this.next = next;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("next")
  public String getNext() {
    return next;
  }
  public void setNext(String next) {
    this.next = next;
  }

  /**
   * minimum: 1
   **/
  public PaginatedPullrequestsCommits pagelen(Integer pagelen) {
    this.pagelen = pagelen;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("pagelen")
 @Min(1)  public Integer getPagelen() {
    return pagelen;
  }
  public void setPagelen(Integer pagelen) {
    this.pagelen = pagelen;
  }

  /**
   * minimum: 1
   **/
  public PaginatedPullrequestsCommits page(Integer page) {
    this.page = page;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("page")
 @Min(1)  public Integer getPage() {
    return page;
  }
  public void setPage(Integer page) {
    this.page = page;
  }

  /**
   **/
  public PaginatedPullrequestsCommits previous(String previous) {
    this.previous = previous;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("previous")
  public String getPrevious() {
    return previous;
  }
  public void setPrevious(String previous) {
    this.previous = previous;
  }

  /**
   **/
  public PaginatedPullrequestsCommits values(List<Commit> values) {
    this.values = values;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("values")
 @Size(min=0)  public List<Commit> getValues() {
    return values;
  }
  public void setValues(List<Commit> values) {
    this.values = values;
  }

  /**
   * minimum: 0
   **/
  public PaginatedPullrequestsCommits size(Integer size) {
    this.size = size;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("size")
 @Min(0)  public Integer getSize() {
    return size;
  }
  public void setSize(Integer size) {
    this.size = size;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedPullrequestsCommits paginatedPullrequestsCommits = (PaginatedPullrequestsCommits) o;
    return Objects.equals(next, paginatedPullrequestsCommits.next) &&
        Objects.equals(pagelen, paginatedPullrequestsCommits.pagelen) &&
        Objects.equals(page, paginatedPullrequestsCommits.page) &&
        Objects.equals(previous, paginatedPullrequestsCommits.previous) &&
        Objects.equals(values, paginatedPullrequestsCommits.values) &&
        Objects.equals(size, paginatedPullrequestsCommits.size);
  }

  @Override
  public int hashCode() {
    return Objects.hash(next, pagelen, page, previous, values, size);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedPullrequestsCommits {\n");
    
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    pagelen: ").append(toIndentedString(pagelen)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

