package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Tag;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A paginated list of tags.
 **/
@ApiModel(description = "A paginated list of tags.")
public class PaginatedTags   {
  
  private @Valid Integer page;
  private @Valid String previous;
  private @Valid Integer pagelen;
  private @Valid String next;
  private @Valid Integer size;
  private @Valid List<Tag> values = new ArrayList<Tag>();

  /**
   * Page number of the current results. This is an optional element that is not provided in all responses.
   * minimum: 1
   **/
  public PaginatedTags page(Integer page) {
    this.page = page;
    return this;
  }

  
  @ApiModelProperty(value = "Page number of the current results. This is an optional element that is not provided in all responses.")
  @JsonProperty("page")
 @Min(1)  public Integer getPage() {
    return page;
  }
  public void setPage(Integer page) {
    this.page = page;
  }

  /**
   * Link to previous page if it exists. A collections first page does not have this value. This is an optional element that is not provided in all responses. Some result sets strictly support forward navigation and never provide previous links. Clients must anticipate that backwards navigation is not always available. Use this link to navigate the result set and refrain from constructing your own URLs.
   **/
  public PaginatedTags previous(String previous) {
    this.previous = previous;
    return this;
  }

  
  @ApiModelProperty(value = "Link to previous page if it exists. A collections first page does not have this value. This is an optional element that is not provided in all responses. Some result sets strictly support forward navigation and never provide previous links. Clients must anticipate that backwards navigation is not always available. Use this link to navigate the result set and refrain from constructing your own URLs.")
  @JsonProperty("previous")
  public String getPrevious() {
    return previous;
  }
  public void setPrevious(String previous) {
    this.previous = previous;
  }

  /**
   * Current number of objects on the existing page. The default value is 10 with 100 being the maximum allowed value. Individual APIs may enforce different values.
   * minimum: 1
   **/
  public PaginatedTags pagelen(Integer pagelen) {
    this.pagelen = pagelen;
    return this;
  }

  
  @ApiModelProperty(value = "Current number of objects on the existing page. The default value is 10 with 100 being the maximum allowed value. Individual APIs may enforce different values.")
  @JsonProperty("pagelen")
 @Min(1)  public Integer getPagelen() {
    return pagelen;
  }
  public void setPagelen(Integer pagelen) {
    this.pagelen = pagelen;
  }

  /**
   * Link to the next page if it exists. The last page of a collection does not have this value. Use this link to navigate the result set and refrain from constructing your own URLs.
   **/
  public PaginatedTags next(String next) {
    this.next = next;
    return this;
  }

  
  @ApiModelProperty(value = "Link to the next page if it exists. The last page of a collection does not have this value. Use this link to navigate the result set and refrain from constructing your own URLs.")
  @JsonProperty("next")
  public String getNext() {
    return next;
  }
  public void setNext(String next) {
    this.next = next;
  }

  /**
   * Total number of objects in the response. This is an optional element that is not provided in all responses, as it can be expensive to compute.
   * minimum: 0
   **/
  public PaginatedTags size(Integer size) {
    this.size = size;
    return this;
  }

  
  @ApiModelProperty(value = "Total number of objects in the response. This is an optional element that is not provided in all responses, as it can be expensive to compute.")
  @JsonProperty("size")
 @Min(0)  public Integer getSize() {
    return size;
  }
  public void setSize(Integer size) {
    this.size = size;
  }

  /**
   **/
  public PaginatedTags values(List<Tag> values) {
    this.values = values;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("values")
 @Size(min=0)  public List<Tag> getValues() {
    return values;
  }
  public void setValues(List<Tag> values) {
    this.values = values;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginatedTags paginatedTags = (PaginatedTags) o;
    return Objects.equals(page, paginatedTags.page) &&
        Objects.equals(previous, paginatedTags.previous) &&
        Objects.equals(pagelen, paginatedTags.pagelen) &&
        Objects.equals(next, paginatedTags.next) &&
        Objects.equals(size, paginatedTags.size) &&
        Objects.equals(values, paginatedTags.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, previous, pagelen, next, size, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginatedTags {\n");
    
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    pagelen: ").append(toIndentedString(pagelen)).append("\n");
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

