package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * An executable pipeline command.
 **/
@ApiModel(description = "An executable pipeline command.")
public class PipelineCommand   {
  
  private @Valid String command;
  private @Valid String name;

  /**
   * The executable command.
   **/
  public PipelineCommand command(String command) {
    this.command = command;
    return this;
  }

  
  @ApiModelProperty(value = "The executable command.")
  @JsonProperty("command")
  public String getCommand() {
    return command;
  }
  public void setCommand(String command) {
    this.command = command;
  }

  /**
   * The name of the command.
   **/
  public PipelineCommand name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of the command.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineCommand pipelineCommand = (PipelineCommand) o;
    return Objects.equals(command, pipelineCommand.command) &&
        Objects.equals(name, pipelineCommand.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(command, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineCommand {\n");
    
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

